/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.tasks;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.PasswordUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.BaseRepositoryImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import icons.TasksCoreIcons;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.GithubConnection;
import org.jetbrains.plugins.github.api.data.GithubIssue;
import org.jetbrains.plugins.github.api.data.GithubIssueComment;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubJsonException;
import org.jetbrains.plugins.github.exceptions.GithubOperationCanceledException;
import org.jetbrains.plugins.github.exceptions.GithubRateLimitExceededException;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;
import org.jetbrains.plugins.github.tasks.GithubComment;
import org.jetbrains.plugins.github.tasks.GithubRepositoryType;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubUtil;

@Tag(value="GitHub")
public class GithubRepository
extends BaseRepositoryImpl {
    private static final Logger LOG = GithubUtil.LOG;
    private Pattern myPattern = Pattern.compile("($^)");
    @NotNull
    private String myRepoAuthor = "";
    @NotNull
    private String myRepoName = "";
    @NotNull
    private String myUser = "";
    @NotNull
    private String myToken = "";
    private boolean myAssignedIssuesOnly = false;

    public GithubRepository() {
    }

    public GithubRepository(GithubRepository other) {
        super((BaseRepositoryImpl)other);
        this.setRepoName(other.myRepoName);
        this.setRepoAuthor(other.myRepoAuthor);
        this.setToken(other.myToken);
        this.setAssignedIssuesOnly(other.myAssignedIssuesOnly);
    }

    public GithubRepository(GithubRepositoryType type) {
        super((TaskRepositoryType)type);
        this.setUrl("https://github.com");
    }

    @NotNull
    public TaskRepository.CancellableConnection createCancellableConnection() {
        TaskRepository.CancellableConnection cancellableConnection = new TaskRepository.CancellableConnection(){
            private final GithubConnection myConnection;
            {
                this.myConnection = new GithubConnection(GithubRepository.this.getAuthData(), false);
            }

            protected void doTest() throws Exception {
                try {
                    GithubApiUtil.getIssuesQueried(this.myConnection, GithubRepository.this.getRepoAuthor(), GithubRepository.this.getRepoName(), null, null, false);
                }
                catch (GithubOperationCanceledException githubOperationCanceledException) {
                    // empty catch block
                }
            }

            public void cancel() {
                this.myConnection.abort();
            }
        };
        if (cancellableConnection == null) {
            GithubRepository.$$$reportNull$$$0(0);
        }
        return cancellableConnection;
    }

    public boolean isConfigured() {
        return super.isConfigured() && !StringUtil.isEmptyOrSpaces((String)this.getRepoAuthor()) && !StringUtil.isEmptyOrSpaces((String)this.getRepoName()) && !StringUtil.isEmptyOrSpaces((String)this.getToken());
    }

    public String getPresentableName() {
        String name = super.getPresentableName();
        return name + (!StringUtil.isEmpty((String)this.getRepoAuthor()) ? "/" + this.getRepoAuthor() : "") + (!StringUtil.isEmpty((String)this.getRepoName()) ? "/" + this.getRepoName() : "");
    }

    public Task[] getIssues(@Nullable String query, int offset, int limit, boolean withClosed) throws Exception {
        try {
            return this.getIssues(query, offset + limit, withClosed);
        }
        catch (GithubRateLimitExceededException e) {
            return new Task[0];
        }
        catch (GithubAuthenticationException | GithubStatusCodeException e) {
            throw new Exception(e.getMessage(), e);
        }
        catch (GithubJsonException e) {
            throw new Exception("Bad response format", e);
        }
    }

    public Task[] getIssues(@Nullable String query, int offset, int limit, boolean withClosed, @NotNull ProgressIndicator cancelled) throws Exception {
        if (cancelled == null) {
            GithubRepository.$$$reportNull$$$0(1);
        }
        return this.getIssues(query, offset, limit, withClosed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Task[] getIssues(@Nullable String query, int max, boolean withClosed) throws Exception {
        Task[] taskArray;
        GithubConnection connection;
        block5: {
            connection = this.getConnection();
            String assigned = null;
            if (this.myAssignedIssuesOnly) {
                if (StringUtil.isEmptyOrSpaces((String)this.myUser)) {
                    this.myUser = GithubApiUtil.getCurrentUser(connection).getLogin();
                }
                assigned = this.myUser;
            }
            List<GithubIssue> issues = StringUtil.isEmptyOrSpaces((String)query) ? GithubApiUtil.getIssuesAssigned(connection, this.getRepoAuthor(), this.getRepoName(), assigned, max, withClosed) : GithubApiUtil.getIssuesQueried(connection, this.getRepoAuthor(), this.getRepoName(), assigned, query, withClosed);
            taskArray = (Task[])ContainerUtil.map2Array(issues, Task.class, issue -> this.createTask((GithubIssue)issue));
            if (taskArray != null) break block5;
            GithubRepository.$$$reportNull$$$0(2);
        }
        return taskArray;
        finally {
            connection.close();
        }
    }

    @NotNull
    private Task createTask(final GithubIssue issue) {
        Task task = new Task(){
            @NotNull
            String myRepoName;
            {
                this.myRepoName = GithubRepository.this.getRepoName();
            }

            public boolean isIssue() {
                return true;
            }

            public String getIssueUrl() {
                return issue.getHtmlUrl();
            }

            @NotNull
            public String getId() {
                String string = this.myRepoName + "-" + issue.getNumber();
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getSummary() {
                String string = issue.getTitle();
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            public String getDescription() {
                return issue.getBody();
            }

            @NotNull
            public Comment[] getComments() {
                Comment[] commentArray;
                try {
                    commentArray = GithubRepository.this.fetchComments(issue.getNumber());
                }
                catch (Exception e) {
                    LOG.warn("Error fetching comments for " + issue.getNumber(), (Throwable)e);
                    if (Comment.EMPTY_ARRAY == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    return Comment.EMPTY_ARRAY;
                }
                if (commentArray == null) {
                    2.$$$reportNull$$$0(2);
                }
                return commentArray;
            }

            @NotNull
            public Icon getIcon() {
                Icon icon = TasksCoreIcons.Github;
                if (icon == null) {
                    2.$$$reportNull$$$0(4);
                }
                return icon;
            }

            @NotNull
            public TaskType getType() {
                TaskType taskType = TaskType.BUG;
                if (taskType == null) {
                    2.$$$reportNull$$$0(5);
                }
                return taskType;
            }

            public Date getUpdated() {
                return issue.getUpdatedAt();
            }

            public Date getCreated() {
                return issue.getCreatedAt();
            }

            public boolean isClosed() {
                return !"open".equals(issue.getState());
            }

            public TaskRepository getRepository() {
                return GithubRepository.this;
            }

            public String getPresentableName() {
                return this.getId() + ": " + this.getSummary();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/plugins/github/tasks/GithubRepository$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSummary";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getComments";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIcon";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getType";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (task == null) {
            GithubRepository.$$$reportNull$$$0(3);
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Comment[] fetchComments(long id) throws Exception {
        try (GithubConnection connection = this.getConnection();){
            List<GithubIssueComment> result = GithubApiUtil.getIssueComments(connection, this.getRepoAuthor(), this.getRepoName(), id);
            Comment[] commentArray = (Comment[])ContainerUtil.map2Array(result, Comment.class, comment -> new GithubComment(comment.getCreatedAt(), comment.getUser().getLogin(), comment.getBodyHtml(), comment.getUser().getAvatarUrl(), comment.getUser().getHtmlUrl()));
            return commentArray;
        }
    }

    @Nullable
    public String extractId(@NotNull String taskName) {
        Matcher matcher;
        if (taskName == null) {
            GithubRepository.$$$reportNull$$$0(4);
        }
        return (matcher = this.myPattern.matcher(taskName)).find() ? matcher.group(1) : null;
    }

    @Nullable
    public Task findTask(@NotNull String id) throws Exception {
        int index;
        if (id == null) {
            GithubRepository.$$$reportNull$$$0(5);
        }
        if ((index = id.lastIndexOf("-")) < 0) {
            return null;
        }
        String numericId = id.substring(index + 1);
        try (GithubConnection connection = this.getConnection();){
            Task task = this.createTask(GithubApiUtil.getIssue(connection, this.getRepoAuthor(), this.getRepoName(), numericId));
            return task;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskState(@NotNull Task task, @NotNull TaskState state) throws Exception {
        if (task == null) {
            GithubRepository.$$$reportNull$$$0(6);
        }
        if (state == null) {
            GithubRepository.$$$reportNull$$$0(7);
        }
        try (GithubConnection connection = this.getConnection();){
            boolean isOpen;
            switch (state) {
                case OPEN: {
                    isOpen = true;
                    break;
                }
                case RESOLVED: {
                    isOpen = false;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown state: " + state);
                }
            }
            GithubApiUtil.setIssueState(connection, this.getRepoAuthor(), this.getRepoName(), task.getNumber(), isOpen);
        }
    }

    @NotNull
    public BaseRepository clone() {
        GithubRepository githubRepository = new GithubRepository(this);
        if (githubRepository == null) {
            GithubRepository.$$$reportNull$$$0(8);
        }
        return githubRepository;
    }

    @NotNull
    public String getRepoName() {
        String string = this.myRepoName;
        if (string == null) {
            GithubRepository.$$$reportNull$$$0(9);
        }
        return string;
    }

    public void setRepoName(@NotNull String repoName) {
        if (repoName == null) {
            GithubRepository.$$$reportNull$$$0(10);
        }
        this.myRepoName = repoName;
        this.myPattern = Pattern.compile("(" + StringUtil.escapeToRegexp((String)repoName) + "\\-\\d+)");
    }

    @NotNull
    public String getRepoAuthor() {
        String string = this.myRepoAuthor;
        if (string == null) {
            GithubRepository.$$$reportNull$$$0(11);
        }
        return string;
    }

    public void setRepoAuthor(@NotNull String repoAuthor) {
        if (repoAuthor == null) {
            GithubRepository.$$$reportNull$$$0(12);
        }
        this.myRepoAuthor = repoAuthor;
    }

    @NotNull
    public String getUser() {
        String string = this.myUser;
        if (string == null) {
            GithubRepository.$$$reportNull$$$0(13);
        }
        return string;
    }

    public void setUser(@NotNull String user) {
        if (user == null) {
            GithubRepository.$$$reportNull$$$0(14);
        }
        this.myUser = user;
    }

    @Transient
    @NotNull
    public String getToken() {
        String string = this.myToken;
        if (string == null) {
            GithubRepository.$$$reportNull$$$0(15);
        }
        return string;
    }

    public void setToken(@NotNull String token) {
        if (token == null) {
            GithubRepository.$$$reportNull$$$0(16);
        }
        this.myToken = token;
        this.setUser("");
    }

    public boolean isAssignedIssuesOnly() {
        return this.myAssignedIssuesOnly;
    }

    public void setAssignedIssuesOnly(boolean value) {
        this.myAssignedIssuesOnly = value;
    }

    @Tag(value="token")
    public String getEncodedToken() {
        return PasswordUtil.encodePassword((String)this.getToken());
    }

    public void setEncodedToken(String password) {
        try {
            this.setToken(PasswordUtil.decodePassword((String)password));
        }
        catch (NumberFormatException e) {
            LOG.warn("Can't decode token", (Throwable)e);
        }
    }

    private GithubAuthData getAuthData() {
        return GithubAuthData.createTokenAuth(this.getUrl(), this.getToken(), this.isUseProxy());
    }

    private GithubConnection getConnection() {
        return new GithubConnection(this.getAuthData(), true);
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof GithubRepository)) {
            return false;
        }
        GithubRepository that = (GithubRepository)((Object)o);
        if (!Comparing.equal((String)this.getRepoAuthor(), (String)that.getRepoAuthor())) {
            return false;
        }
        if (!Comparing.equal((String)this.getRepoName(), (String)that.getRepoName())) {
            return false;
        }
        if (!Comparing.equal((String)this.getToken(), (String)that.getToken())) {
            return false;
        }
        return Comparing.equal((Object)this.isAssignedIssuesOnly(), (Object)that.isAssignedIssuesOnly());
    }

    public int hashCode() {
        return StringUtil.stringHashCode((CharSequence)this.getRepoName()) + 31 * StringUtil.stringHashCode((CharSequence)this.getRepoAuthor());
    }

    protected int getFeatures() {
        return super.getFeatures() | 8;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/tasks/GithubRepository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelled";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoAuthor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCancellableConnection";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/tasks/GithubRepository";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssues";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTask";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepoName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepoAuthor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUser";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getToken";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getIssues";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractId";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findTask";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setTaskState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setRepoName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setRepoAuthor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setUser";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setToken";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

