/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.util;

import javax.annotation.Nonnull;
import org.fest.reflect.core.Reflection;
import org.fest.swing.util.SystemPropertyWriter;
import org.fest.util.VisibleForTesting;

public final class AWTExceptionHandlerInstaller {
    private static final SystemPropertyWriter WRITER = new SystemPropertyWriter();

    public static void installAWTExceptionHandler(@Nonnull Class<?> exceptionHandlerType) {
        if (exceptionHandlerType == null) {
            AWTExceptionHandlerInstaller.$$$reportNull$$$0(0);
        }
        AWTExceptionHandlerInstaller.installAWTExceptionHandler(exceptionHandlerType, WRITER);
    }

    @VisibleForTesting
    static void installAWTExceptionHandler(@Nonnull Class<?> exceptionHandlerType, SystemPropertyWriter writer) {
        if (exceptionHandlerType == null) {
            AWTExceptionHandlerInstaller.$$$reportNull$$$0(1);
        }
        try {
            Reflection.constructor().in(exceptionHandlerType).target();
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("The exception handler type should have a default constructor");
        }
        writer.updateSystemProperty("sun.awt.exception.handler", exceptionHandlerType.getName());
    }

    private AWTExceptionHandlerInstaller() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", "exceptionHandlerType", "org/fest/swing/util/AWTExceptionHandlerInstaller", "installAWTExceptionHandler"));
    }
}

