/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.text;

import java.awt.Component;
import java.awt.Container;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.text.AbstractButtonTextReader;
import org.fest.swing.text.JLabelTextReader;
import org.fest.swing.text.JListTextReader;
import org.fest.swing.text.JTextComponentTextReader;
import org.fest.swing.text.TextReader;
import org.fest.util.Maps;
import org.fest.util.Preconditions;
import org.fest.util.Strings;
import org.fest.util.VisibleForTesting;

public class TextReaders {
    private static Logger logger = Logger.getLogger(TextReaders.class.getCanonicalName());
    @VisibleForTesting
    final ConcurrentMap<Class<?>, TextReader<?>> readers = Maps.newConcurrentHashMap();

    @VisibleForTesting
    TextReaders() {
        this.register(new AbstractButtonTextReader());
        this.register(new JLabelTextReader());
        this.register(new JListTextReader());
        this.register(new JTextComponentTextReader());
    }

    public void register(@Nonnull TextReader<?> reader) {
        if (reader == null) {
            TextReaders.$$$reportNull$$$0(0);
        }
        Preconditions.checkNotNull(reader);
        Class type = (Class)Preconditions.checkNotNull(reader.supportedComponent());
        TextReader<?> old = this.readers.put(type, reader);
        if (old != null) {
            logger.info(Strings.concat((Object[])new Object[]{"Replaced reader for type ", type.getName()}));
        }
    }

    @RunsInEDT
    public boolean containsText(final @Nonnull Container container, final @Nonnull String text) {
        if (container == null) {
            TextReaders.$$$reportNull$$$0(1);
        }
        if (text == null) {
            TextReaders.$$$reportNull$$$0(2);
        }
        Preconditions.checkNotNull((Object)container);
        Preconditions.checkNotNull((Object)text);
        Boolean result = GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            @Nullable
            protected Boolean executeInEDT() {
                if (TextReaders.this.componentContainsText(container, text)) {
                    return true;
                }
                return TextReaders.this.anyComponentContainsText(container.getComponents(), text);
            }
        });
        return (Boolean)Preconditions.checkNotNull((Object)result);
    }

    private boolean anyComponentContainsText(@Nonnull Component[] components, @Nonnull String text) {
        if (components == null) {
            TextReaders.$$$reportNull$$$0(3);
        }
        if (text == null) {
            TextReaders.$$$reportNull$$$0(4);
        }
        for (Component c : components) {
            if (c == null) continue;
            if (this.componentContainsText(c, text)) {
                return true;
            }
            if (!(c instanceof Container)) continue;
            Component[] children = ((Container)c).getComponents();
            return this.anyComponentContainsText(children, text);
        }
        return false;
    }

    private boolean componentContainsText(@Nonnull Component c, @Nonnull String text) {
        TextReader<?> reader;
        if (c == null) {
            TextReaders.$$$reportNull$$$0(5);
        }
        if (text == null) {
            TextReaders.$$$reportNull$$$0(6);
        }
        if ((reader = this.readerFor(c)) == null) {
            return false;
        }
        return reader.containsText(c, text);
    }

    @Nullable
    private TextReader<?> readerFor(@Nonnull Component c) {
        if (c == null) {
            TextReaders.$$$reportNull$$$0(7);
        }
        for (Class<?> type = c.getClass(); type != null; type = type.getSuperclass()) {
            TextReader reader = (TextReader)this.readers.get(type);
            if (reader != null) {
                return reader;
            }
            if (type.equals(Component.class)) break;
        }
        return null;
    }

    @Nonnull
    public static TextReaders instance() {
        TextReaders textReaders = SingletonHolder.INSTANCE;
        if (textReaders == null) {
            TextReaders.$$$reportNull$$$0(8);
        }
        return textReaders;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/text/TextReaders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/text/TextReaders";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "instance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "containsText";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "anyComponentContainsText";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "componentContainsText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readerFor";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SingletonHolder {
        static final TextReaders INSTANCE = new TextReaders();

        private SingletonHolder() {
        }
    }
}

