/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.text;

import javax.annotation.Nonnull;
import javax.swing.JList;
import javax.swing.ListModel;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.cell.JListCellReader;
import org.fest.swing.driver.BasicJListCellReader;
import org.fest.swing.text.TextReader;
import org.fest.util.VisibleForTesting;

public class JListTextReader
extends TextReader<JList> {
    private final JListCellReader cellReader;

    public JListTextReader() {
        this(new BasicJListCellReader());
    }

    @VisibleForTesting
    JListTextReader(@Nonnull JListCellReader cellReader) {
        if (cellReader == null) {
            JListTextReader.$$$reportNull$$$0(0);
        }
        this.cellReader = cellReader;
    }

    @Override
    @Nonnull
    public Class<JList> supportedComponent() {
        if (JList.class == null) {
            JListTextReader.$$$reportNull$$$0(1);
        }
        return JList.class;
    }

    @Override
    @RunsInCurrentThread
    protected boolean checkContainsText(@Nonnull JList list, @Nonnull String text) {
        if (list == null) {
            JListTextReader.$$$reportNull$$$0(2);
        }
        if (text == null) {
            JListTextReader.$$$reportNull$$$0(3);
        }
        ListModel model = list.getModel();
        int elementCount = model.getSize();
        for (int i = 0; i < elementCount; ++i) {
            String elementText = this.cellReader.valueAt(list, i);
            if (elementText == null || !elementText.contains(text)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellReader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/text/JListTextReader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/text/JListTextReader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "supportedComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkContainsText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

