/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.query.ComponentParentQuery;
import org.fest.util.Maps;
import org.fest.util.Sets;

class WindowEventQueueMapping {
    final Map<EventQueue, Map<Window, Boolean>> queueMap = Maps.newWeakHashMap();

    WindowEventQueueMapping() {
    }

    void addQueueFor(@Nonnull Toolkit toolkit) {
        if (toolkit == null) {
            WindowEventQueueMapping.$$$reportNull$$$0(0);
        }
        WeakHashMap map = Maps.newWeakHashMap();
        this.queueMap.put(toolkit.getSystemEventQueue(), map);
    }

    void addQueueFor(@Nonnull Component component) {
        EventQueue queue;
        Map<Window, Boolean> windowMapping;
        if (component == null) {
            WindowEventQueueMapping.$$$reportNull$$$0(1);
        }
        if ((windowMapping = this.queueMap.get(queue = component.getToolkit().getSystemEventQueue())) == null) {
            windowMapping = this.createWindowMapping(queue);
        }
        if (!(component instanceof Window) || ComponentParentQuery.parentOf(component) != null) {
            return;
        }
        windowMapping.put((Window)component, Boolean.TRUE);
    }

    @Nonnull
    private Map<Window, Boolean> createWindowMapping(EventQueue queue) {
        WeakHashMap windowMapping = Maps.newWeakHashMap();
        this.queueMap.put(queue, windowMapping);
        WeakHashMap weakHashMap = windowMapping;
        if (weakHashMap == null) {
            WindowEventQueueMapping.$$$reportNull$$$0(2);
        }
        return weakHashMap;
    }

    @RunsInCurrentThread
    void removeMappingFor(@Nonnull Component component) {
        if (component == null) {
            WindowEventQueueMapping.$$$reportNull$$$0(3);
        }
        EventQueue queue = component.getToolkit().getSystemEventQueue();
        this.removeComponent(component, queue);
        for (EventQueue q : this.queueMap.keySet()) {
            this.removeComponent(component, q);
        }
    }

    private void removeComponent(@Nonnull Component component, @Nonnull EventQueue queue) {
        Map<Window, Boolean> windowMapping;
        if (component == null) {
            WindowEventQueueMapping.$$$reportNull$$$0(4);
        }
        if (queue == null) {
            WindowEventQueueMapping.$$$reportNull$$$0(5);
        }
        if ((windowMapping = this.queueMap.get(queue)) != null) {
            windowMapping.remove(component);
        }
    }

    @Nonnull
    Collection<Window> windows() {
        HashSet rootWindows = Sets.newHashSet();
        for (EventQueue queue : this.queueMap.keySet()) {
            rootWindows.addAll(this.queueMap.get(queue).keySet());
        }
        HashSet hashSet = rootWindows;
        if (hashSet == null) {
            WindowEventQueueMapping.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    @Nonnull
    Collection<EventQueue> eventQueues() {
        Set<EventQueue> set = this.queueMap.keySet();
        if (set == null) {
            WindowEventQueueMapping.$$$reportNull$$$0(7);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolkit";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/monitor/WindowEventQueueMapping";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/monitor/WindowEventQueueMapping";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createWindowMapping";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "windows";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "eventQueues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addQueueFor";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeMappingFor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

