/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.annotation.Nonnull;
import javax.swing.SwingUtilities;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.listener.WeakEventListener;
import org.fest.swing.monitor.Windows;

final class WindowAvailabilityMonitor
implements AWTEventListener {
    private static final long EVENT_MASK = 8240L;
    private final Windows windows;

    WindowAvailabilityMonitor(@Nonnull Windows windows) {
        if (windows == null) {
            WindowAvailabilityMonitor.$$$reportNull$$$0(0);
        }
        this.windows = windows;
    }

    void attachTo(@Nonnull Toolkit toolkit) {
        if (toolkit == null) {
            WindowAvailabilityMonitor.$$$reportNull$$$0(1);
        }
        WeakEventListener.attachAsWeakEventListener(toolkit, this, 8240L);
    }

    @Override
    @RunsInEDT
    public void eventDispatched(AWTEvent e) {
        if (!(e instanceof MouseEvent)) {
            return;
        }
        Object source = e.getSource();
        if (!(source instanceof Component)) {
            return;
        }
        Component c = (Component)source;
        Window w = c instanceof Window ? (Window)c : SwingUtilities.getWindowAncestor(c);
        this.windows.markAsReady(w);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windows";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolkit";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/monitor/WindowAvailabilityMonitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "attachTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

