/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.applet.Applet;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.monitor.EventQueueMapping;
import org.fest.swing.monitor.WindowEventQueueMapping;
import org.fest.util.Lists;
import org.fest.util.Sets;

@ThreadSafe
class Context {
    @GuardedBy(value="lock")
    private final WindowEventQueueMapping windowEventQueueMapping;
    @GuardedBy(value="lock")
    private final EventQueueMapping eventQueueMapping;
    private final Object lock;

    Context(@Nonnull Toolkit toolkit) {
        if (toolkit == null) {
            Context.$$$reportNull$$$0(0);
        }
        this(toolkit, new WindowEventQueueMapping(), new EventQueueMapping());
    }

    Context(@Nonnull Toolkit toolkit, @Nonnull WindowEventQueueMapping windowEventQueueMapping, @Nonnull EventQueueMapping eventQueueMapping) {
        if (toolkit == null) {
            Context.$$$reportNull$$$0(1);
        }
        if (windowEventQueueMapping == null) {
            Context.$$$reportNull$$$0(2);
        }
        if (eventQueueMapping == null) {
            Context.$$$reportNull$$$0(3);
        }
        this.lock = new Object();
        this.windowEventQueueMapping = windowEventQueueMapping;
        this.eventQueueMapping = eventQueueMapping;
        this.windowEventQueueMapping.addQueueFor(toolkit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    Collection<Window> rootWindows() {
        LinkedHashSet rootWindows = Sets.newLinkedHashSet();
        Object object = this.lock;
        synchronized (object) {
            rootWindows.addAll(this.windowEventQueueMapping.windows());
        }
        rootWindows.addAll(Lists.newArrayList((Object[])Frame.getFrames()));
        rootWindows.addAll(Lists.newArrayList((Object[])Window.getOwnerlessWindows()));
        LinkedHashSet linkedHashSet = rootWindows;
        if (linkedHashSet == null) {
            Context.$$$reportNull$$$0(4);
        }
        return linkedHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    EventQueue storedQueueFor(@Nonnull Component c) {
        if (c == null) {
            Context.$$$reportNull$$$0(5);
        }
        Object object = this.lock;
        synchronized (object) {
            return this.eventQueueMapping.storedQueueFor(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeContextFor(@Nonnull Component component) {
        if (component == null) {
            Context.$$$reportNull$$$0(6);
        }
        Object object = this.lock;
        synchronized (object) {
            this.windowEventQueueMapping.removeMappingFor(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addContextFor(@Nonnull Component component) {
        if (component == null) {
            Context.$$$reportNull$$$0(7);
        }
        Object object = this.lock;
        synchronized (object) {
            this.windowEventQueueMapping.addQueueFor(component);
            this.eventQueueMapping.addQueueFor(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @RunsInEDT
    EventQueue eventQueueFor(@Nonnull Component c) {
        Component component;
        if (c == null) {
            Context.$$$reportNull$$$0(8);
        }
        if ((component = Context.topParentOf(c)) == null) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            return this.eventQueueMapping.queueFor(component);
        }
    }

    @Nullable
    @RunsInEDT
    private static Component topParentOf(final @Nonnull Component c) {
        if (c == null) {
            Context.$$$reportNull$$$0(9);
        }
        return GuiActionRunner.execute(new GuiQuery<Component>(){

            @Override
            @Nullable
            protected Component executeInEDT() {
                Component parent = c;
                while (!(parent instanceof Applet) && parent.getParent() != null) {
                    parent = parent.getParent();
                }
                return parent;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    Collection<EventQueue> allEventQueues() {
        LinkedHashSet eventQueues = Sets.newLinkedHashSet();
        Object object = this.lock;
        synchronized (object) {
            eventQueues.addAll(this.windowEventQueueMapping.eventQueues());
            eventQueues.addAll(this.eventQueueMapping.eventQueues());
        }
        LinkedHashSet linkedHashSet = eventQueues;
        if (linkedHashSet == null) {
            Context.$$$reportNull$$$0(10);
        }
        return linkedHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 10: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolkit";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windowEventQueueMapping";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventQueueMapping";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/monitor/Context";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/monitor/Context";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "rootWindows";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "allEventQueues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "storedQueueFor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeContextFor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addContextFor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "eventQueueFor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "topParentOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

