/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.keystroke;

import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.fest.swing.keystroke.KeyStrokeMappingProvider;
import org.fest.swing.util.OSFamily;
import org.fest.util.Strings;

class KeyStrokeMappingProviderNames
implements Iterable<String> {
    private final String osFamily;
    private final String language;
    private final String country;

    static KeyStrokeMappingProviderNames generateNamesFrom(@Nonnull OSFamily osFamily, @Nonnull Locale locale) {
        if (osFamily == null) {
            KeyStrokeMappingProviderNames.$$$reportNull$$$0(0);
        }
        if (locale == null) {
            KeyStrokeMappingProviderNames.$$$reportNull$$$0(1);
        }
        return new KeyStrokeMappingProviderNames(osFamily, locale);
    }

    private KeyStrokeMappingProviderNames(@Nonnull OSFamily osFamily, @Nonnull Locale locale) {
        if (osFamily == null) {
            KeyStrokeMappingProviderNames.$$$reportNull$$$0(2);
        }
        if (locale == null) {
            KeyStrokeMappingProviderNames.$$$reportNull$$$0(3);
        }
        this.osFamily = osFamily.key();
        this.language = locale.getLanguage();
        this.country = locale.getCountry();
    }

    @Override
    public Iterator<String> iterator() {
        return new NameIterator(this.osFamily, this.language, this.country);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "osFamily";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locale";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/keystroke/KeyStrokeMappingProviderNames";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "generateNamesFrom";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class NameIterator
    implements Iterator<String> {
        private static final String PREFIX = KeyStrokeMappingProvider.class.getName();
        private static final String DELIMETER = "_";
        private final String osFamily;
        private final String language;
        private final String country;
        private State state;

        NameIterator(String osFamily, String language, String country) {
            this.osFamily = osFamily;
            this.language = language;
            this.country = country;
            this.state = State.FULL_NAME;
        }

        @Override
        public String next() {
            switch (this.state) {
                case FULL_NAME: {
                    this.state = State.WITHOUT_COUNTRY;
                    return Strings.join((String[])new String[]{PREFIX, this.osFamily, this.language, this.country}).with(DELIMETER);
                }
                case WITHOUT_COUNTRY: {
                    this.state = State.LANGUAGE_ONLY;
                    return Strings.join((String[])new String[]{PREFIX, this.osFamily, this.language}).with(DELIMETER);
                }
                case LANGUAGE_ONLY: {
                    this.state = State.END;
                    return Strings.join((String[])new String[]{PREFIX, this.language}).with(DELIMETER);
                }
            }
            throw new NoSuchElementException("There are no more names to generate");
        }

        @Override
        public boolean hasNext() {
            return this.state != State.END;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator does not support 'remove'");
        }

        private static enum State {
            FULL_NAME,
            WITHOUT_COUNTRY,
            LANGUAGE_ONLY,
            END;

        }
    }
}

