/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.input;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.reflect.core.Reflection;
import org.fest.reflect.exception.ReflectionError;

class DragDropInfo {
    private Component source;
    private int x;
    private int y;

    DragDropInfo() {
    }

    void clear() {
        this.source(null);
    }

    void update(@Nonnull MouseEvent event) {
        int mouseEventId;
        if (event == null) {
            DragDropInfo.$$$reportNull$$$0(0);
        }
        if ((mouseEventId = event.getID()) == 502 || mouseEventId == 503) {
            this.clear();
            return;
        }
        if (mouseEventId == 501) {
            this.source(event.getComponent());
            this.x = event.getX();
            this.y = event.getY();
        }
    }

    @Nullable
    Component source() {
        return this.source;
    }

    void source(@Nullable Component newSource) {
        this.source = newSource;
    }

    boolean isDragging() {
        return this.source != null;
    }

    @Nonnull
    Point origin() {
        Point point = new Point(this.x, this.y);
        if (point == null) {
            DragDropInfo.$$$reportNull$$$0(1);
        }
        return point;
    }

    void origin(@Nonnull Point origin) {
        if (origin == null) {
            DragDropInfo.$$$reportNull$$$0(2);
        }
        this.x = origin.x;
        this.y = origin.y;
    }

    boolean isNativeDragActive() {
        try {
            Class<?> type = Class.forName("sun.awt.dnd.SunDragSourceContextPeer");
            try {
                Reflection.method((String)"checkDragDropInProgress").in(type).invoke(new Object[0]);
                return false;
            }
            catch (ReflectionError e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof InvocationTargetException)) {
                    return false;
                }
                return ((InvocationTargetException)cause).getTargetException() instanceof InvalidDnDOperationException;
            }
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/input/DragDropInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/input/DragDropInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "origin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "origin";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

