/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.input;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.util.EmptyStackException;
import javax.annotation.Nonnull;
import javax.swing.SwingUtilities;
import org.fest.swing.input.NativeDndIdentifier;

class DragAwareEventQueue
extends EventQueue {
    private final Toolkit toolkit;
    private final long mask;
    private final AWTEventListener eventListener;
    private final NativeDndIdentifier nativeDnd;

    /*
     * WARNING - void declaration
     */
    DragAwareEventQueue(@Nonnull Toolkit toolkit, long mask, @Nonnull AWTEventListener aWTEventListener) {
        void eventListener;
        if (toolkit == null) {
            DragAwareEventQueue.$$$reportNull$$$0(0);
        }
        if (aWTEventListener == null) {
            DragAwareEventQueue.$$$reportNull$$$0(1);
        }
        this(toolkit, mask, (AWTEventListener)eventListener, new NativeDndIdentifier());
    }

    /*
     * WARNING - void declaration
     */
    DragAwareEventQueue(@Nonnull Toolkit toolkit, long mask, @Nonnull AWTEventListener eventListener, @Nonnull NativeDndIdentifier nativeDndIdentifier) {
        void nativeDnd;
        if (toolkit == null) {
            DragAwareEventQueue.$$$reportNull$$$0(2);
        }
        if (eventListener == null) {
            DragAwareEventQueue.$$$reportNull$$$0(3);
        }
        if (nativeDndIdentifier == null) {
            DragAwareEventQueue.$$$reportNull$$$0(4);
        }
        this.toolkit = toolkit;
        this.mask = mask;
        this.eventListener = eventListener;
        this.nativeDnd = nativeDnd;
    }

    @Override
    public void pop() throws EmptyStackException {
        EventQueue systemEventQueue = this.toolkit.getSystemEventQueue();
        if (systemEventQueue == this) {
            super.pop();
        }
    }

    @Override
    protected void dispatchEvent(AWTEvent e) {
        if (this.nativeDnd.isNativeDragAndDrop(e)) {
            MouseEvent mouseEvent = (MouseEvent)e;
            Component target = SwingUtilities.getDeepestComponentAt(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            if (target != mouseEvent.getSource()) {
                mouseEvent = SwingUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, target);
            }
            this.relayDndEvent(mouseEvent);
        }
        super.dispatchEvent(e);
    }

    private void relayDndEvent(@Nonnull MouseEvent event) {
        int eventId;
        if (event == null) {
            DragAwareEventQueue.$$$reportNull$$$0(5);
        }
        if ((eventId = event.getID()) == 503 || eventId == 506) {
            if ((this.mask & 0x20L) != 0L) {
                this.eventListener.eventDispatched(event);
            }
            return;
        }
        if (eventId >= 500 && eventId <= 507 && (this.mask & 0x10L) != 0L) {
            this.eventListener.eventDispatched(event);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolkit";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventListener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeDnd";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/input/DragAwareEventQueue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "relayDndEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

