/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.input;

import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.util.EmptyStackException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.fest.swing.input.DragAwareEventQueue;
import org.fest.swing.input.EventNormalizer;
import org.fest.util.VisibleForTesting;

class DragAwareEventNormalizer
extends EventNormalizer {
    private static Logger logger = Logger.getLogger(DragAwareEventNormalizer.class.getCanonicalName());
    private DragAwareEventQueue dragAwareEventQueue;

    DragAwareEventNormalizer() {
    }

    @Override
    public void startListening(@Nonnull Toolkit toolkit, @Nonnull AWTEventListener delegate, long mask) {
        if (toolkit == null) {
            DragAwareEventNormalizer.$$$reportNull$$$0(0);
        }
        if (delegate == null) {
            DragAwareEventNormalizer.$$$reportNull$$$0(1);
        }
        super.startListening(toolkit, delegate, mask);
        try {
            this.dragAwareEventQueue = this.createEventQueue(toolkit, mask);
            toolkit.getSystemEventQueue().push(this.dragAwareEventQueue);
        }
        catch (RuntimeException e) {
            String msg = String.format("Ignoring error when starting up %s", DragAwareEventNormalizer.class.getName());
            logger.log(Level.WARNING, msg, e);
        }
    }

    @VisibleForTesting
    DragAwareEventQueue createEventQueue(@Nonnull Toolkit toolkit, long mask) {
        if (toolkit == null) {
            DragAwareEventNormalizer.$$$reportNull$$$0(2);
        }
        return new DragAwareEventQueue(toolkit, mask, this);
    }

    @Override
    public void stopListening() {
        this.disposeDragAwareEventQueue();
        super.stopListening();
    }

    private void disposeDragAwareEventQueue() {
        if (this.dragAwareEventQueue == null) {
            return;
        }
        try {
            this.dragAwareEventQueue.pop();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        this.dragAwareEventQueue = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolkit";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/input/DragAwareEventNormalizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "startListening";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createEventQueue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

