/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.hierarchy;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.SwingUtilities;
import org.fest.swing.hierarchy.ComponentHierarchy;
import org.fest.util.Lists;

public final class SingleComponentHierarchy
implements ComponentHierarchy {
    private final Container root;
    private final List<Container> list;
    private final ComponentHierarchy hierarchy;

    public SingleComponentHierarchy(@Nonnull Container root, @Nonnull ComponentHierarchy hierarchy) {
        if (root == null) {
            SingleComponentHierarchy.$$$reportNull$$$0(0);
        }
        if (hierarchy == null) {
            SingleComponentHierarchy.$$$reportNull$$$0(1);
        }
        this.list = Lists.newArrayList();
        this.root = root;
        this.hierarchy = hierarchy;
        this.list.add(root);
    }

    public Container root() {
        return this.root;
    }

    @Override
    @Nullable
    public Container parentOf(@Nonnull Component c) {
        if (c == null) {
            SingleComponentHierarchy.$$$reportNull$$$0(2);
        }
        return this.hierarchy.parentOf(c);
    }

    @Override
    @Nonnull
    public Collection<Container> roots() {
        List<Container> list = this.list;
        if (list == null) {
            SingleComponentHierarchy.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @Nonnull
    public Collection<Component> childrenOf(@Nonnull Component c) {
        if (c == null) {
            SingleComponentHierarchy.$$$reportNull$$$0(4);
        }
        Collection<Component> collection = this.hierarchy.childrenOf(c);
        if (collection == null) {
            SingleComponentHierarchy.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @Override
    public boolean contains(@Nonnull Component c) {
        if (c == null) {
            SingleComponentHierarchy.$$$reportNull$$$0(6);
        }
        return this.hierarchy.contains(c) && SwingUtilities.isDescendingFrom(c, this.root);
    }

    @Override
    public void dispose(@Nonnull Window w) {
        if (w == null) {
            SingleComponentHierarchy.$$$reportNull$$$0(7);
        }
        this.hierarchy.dispose(w);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchy";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/hierarchy/SingleComponentHierarchy";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "w";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/hierarchy/SingleComponentHierarchy";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "roots";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "childrenOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parentOf";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "childrenOf";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

