/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.hierarchy;

import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.hierarchy.ExistingHierarchy;
import org.fest.swing.hierarchy.TransientWindowListener;
import org.fest.swing.hierarchy.WindowFilter;
import org.fest.swing.listener.WeakEventListener;
import org.fest.swing.util.ToolkitProvider;
import org.fest.util.Lists;
import org.fest.util.VisibleForTesting;

public class NewHierarchy
extends ExistingHierarchy {
    private final WindowFilter filter;
    private final TransientWindowListener transientWindowListener;

    @Nonnull
    public static NewHierarchy ignoreExistingComponents() {
        NewHierarchy newHierarchy = new NewHierarchy(true);
        if (newHierarchy == null) {
            NewHierarchy.$$$reportNull$$$0(0);
        }
        return newHierarchy;
    }

    @Nonnull
    public static NewHierarchy includeExistingComponents() {
        NewHierarchy newHierarchy = new NewHierarchy(false);
        if (newHierarchy == null) {
            NewHierarchy.$$$reportNull$$$0(1);
        }
        return newHierarchy;
    }

    private NewHierarchy(boolean ignoreExisting) {
        this(ToolkitProvider.instance().defaultToolkit(), ignoreExisting);
    }

    private NewHierarchy(@Nonnull Toolkit toolkit, boolean ignoreExisting) {
        if (toolkit == null) {
            NewHierarchy.$$$reportNull$$$0(2);
        }
        this.filter = new WindowFilter(this.parentFinder(), this.childrenFinder());
        this.transientWindowListener = new TransientWindowListener(this.filter);
        this.setUp(toolkit, ignoreExisting);
    }

    @VisibleForTesting
    NewHierarchy(@Nonnull Toolkit toolkit, @Nonnull WindowFilter filter, boolean ignoreExisting) {
        if (toolkit == null) {
            NewHierarchy.$$$reportNull$$$0(3);
        }
        if (filter == null) {
            NewHierarchy.$$$reportNull$$$0(4);
        }
        this.filter = filter;
        this.transientWindowListener = new TransientWindowListener(filter);
        this.setUp(toolkit, ignoreExisting);
    }

    @RunsInCurrentThread
    private void setUp(@Nonnull Toolkit toolkit, boolean ignoreExisting) {
        if (toolkit == null) {
            NewHierarchy.$$$reportNull$$$0(5);
        }
        if (ignoreExisting) {
            this.ignoreExisting();
        }
        WeakEventListener.attachAsWeakEventListener(toolkit, this.transientWindowListener, 65L);
    }

    @RunsInCurrentThread
    public void ignoreExisting() {
        for (Container c : this.roots()) {
            if (c == null) continue;
            this.filter.ignore(c);
        }
    }

    @RunsInCurrentThread
    public void recognize(@Nonnull Component c) {
        if (c == null) {
            NewHierarchy.$$$reportNull$$$0(6);
        }
        this.filter.recognize(c);
    }

    @Override
    @Nonnull
    @RunsInCurrentThread
    public Collection<Component> childrenOf(@Nonnull Component c) {
        if (c == null) {
            NewHierarchy.$$$reportNull$$$0(7);
        }
        if (this.filter.isIgnored(c)) {
            List list = Lists.emptyList();
            if (list == null) {
                NewHierarchy.$$$reportNull$$$0(8);
            }
            return list;
        }
        Collection<Component> children = super.childrenOf(c);
        children.removeAll(this.filter.filtered());
        Collection<Component> collection = children;
        if (collection == null) {
            NewHierarchy.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @Override
    @RunsInCurrentThread
    public boolean contains(@Nonnull Component c) {
        if (c == null) {
            NewHierarchy.$$$reportNull$$$0(10);
        }
        return super.contains(c) && !this.filter.isIgnored(c);
    }

    @Override
    @RunsInCurrentThread
    public void dispose(@Nonnull Window w) {
        if (w == null) {
            NewHierarchy.$$$reportNull$$$0(11);
        }
        if (!this.contains(w)) {
            return;
        }
        super.dispose(w);
        this.filter.ignore(w);
    }

    @Override
    @Nonnull
    public Collection<Container> roots() {
        Collection<Container> roots = super.roots();
        roots.removeAll(this.filter.filtered());
        Collection<Container> collection = roots;
        if (collection == null) {
            NewHierarchy.$$$reportNull$$$0(12);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/hierarchy/NewHierarchy";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolkit";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "w";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ignoreExistingComponents";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "includeExistingComponents";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/hierarchy/NewHierarchy";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "childrenOf";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setUp";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "recognize";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "childrenOf";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

