/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.hierarchy;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.hierarchy.ChildrenFinderStrategy;
import org.fest.swing.hierarchy.JDesktopPaneChildrenFinder;
import org.fest.swing.hierarchy.JMenuChildrenFinder;
import org.fest.swing.hierarchy.WindowChildrenFinder;
import org.fest.util.Lists;
import org.fest.util.VisibleForTesting;

class ChildrenFinder {
    private static List<ChildrenFinderStrategy> strategies = Lists.newArrayList((Object[])new ChildrenFinderStrategy[]{new JDesktopPaneChildrenFinder(), new JMenuChildrenFinder(), new WindowChildrenFinder()});

    ChildrenFinder() {
    }

    @Nonnull
    @RunsInCurrentThread
    Collection<Component> childrenOf(@Nonnull Component c) {
        if (c == null) {
            ChildrenFinder.$$$reportNull$$$0(0);
        }
        if (!(c instanceof Container)) {
            List list = Lists.emptyList();
            if (list == null) {
                ChildrenFinder.$$$reportNull$$$0(1);
            }
            return list;
        }
        Container container = (Container)c;
        ArrayList children = Lists.newArrayList((Object[])container.getComponents());
        children.addAll(this.nonExplicitChildrenOf(container));
        ArrayList arrayList = children;
        if (arrayList == null) {
            ChildrenFinder.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Nonnull
    private Collection<Component> nonExplicitChildrenOf(@Nonnull Container c) {
        if (c == null) {
            ChildrenFinder.$$$reportNull$$$0(3);
        }
        ArrayList children = Lists.newArrayList();
        for (ChildrenFinderStrategy s : strategies) {
            children.addAll(s.nonExplicitChildrenOf(c));
        }
        ArrayList arrayList = children;
        if (arrayList == null) {
            ChildrenFinder.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nonnull
    @VisibleForTesting
    static List<ChildrenFinderStrategy> strategies() {
        ArrayList arrayList = Lists.newArrayList(strategies);
        if (arrayList == null) {
            ChildrenFinder.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @VisibleForTesting
    static void replaceStrategiesWith(@Nonnull List<ChildrenFinderStrategy> newStrategies) {
        if (newStrategies == null) {
            ChildrenFinder.$$$reportNull$$$0(6);
        }
        strategies = Lists.newArrayList(newStrategies);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/hierarchy/ChildrenFinder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newStrategies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/hierarchy/ChildrenFinder";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "childrenOf";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "nonExplicitChildrenOf";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "strategies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "childrenOf";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "nonExplicitChildrenOf";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replaceStrategiesWith";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

