/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.format;

import java.awt.Component;
import javax.annotation.Nonnull;
import javax.swing.JFileChooser;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.format.ComponentFormatterTemplate;
import org.fest.swing.format.IntEnum;
import org.fest.util.Strings;
import org.fest.util.ToString;

public class JFileChooserFormatter
extends ComponentFormatterTemplate {
    private static final IntEnum DIALOG_TYPES = new IntEnum();

    @Override
    @Nonnull
    @RunsInCurrentThread
    protected String doFormat(@Nonnull Component c) {
        if (c == null) {
            JFileChooserFormatter.$$$reportNull$$$0(0);
        }
        JFileChooser fileChooser = (JFileChooser)c;
        String format = "%s[name=%s, dialogTitle=%s, dialogType=%s, currentDirectory=%s, enabled=%b, visible=%b, showing=%b";
        String string = String.format(format, fileChooser.getClass().getName(), Strings.quote((String)fileChooser.getName()), Strings.quote((String)fileChooser.getDialogTitle()), DIALOG_TYPES.get(fileChooser.getDialogType()), ToString.toStringOf((Object)fileChooser.getCurrentDirectory()), fileChooser.isEnabled(), fileChooser.isVisible(), fileChooser.isShowing());
        if (string == null) {
            JFileChooserFormatter.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nonnull
    public Class<? extends Component> targetType() {
        if (JFileChooser.class == null) {
            JFileChooserFormatter.$$$reportNull$$$0(2);
        }
        return JFileChooser.class;
    }

    static {
        DIALOG_TYPES.put(0, "OPEN_DIALOG").put(1, "SAVE_DIALOG").put(2, "CUSTOM_DIALOG");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/format/JFileChooserFormatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/format/JFileChooserFormatter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "doFormat";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "targetType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doFormat";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

