/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.format;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.text.JTextComponent;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.format.ComponentFormatter;
import org.fest.swing.format.IntrospectionComponentFormatter;
import org.fest.swing.format.JComboBoxFormatter;
import org.fest.swing.format.JFileChooserFormatter;
import org.fest.swing.format.JListFormatter;
import org.fest.swing.format.JOptionPaneFormatter;
import org.fest.swing.format.JTabbedPaneFormatter;
import org.fest.swing.format.JTableFormatter;
import org.fest.swing.format.JTreeFormatter;
import org.fest.util.Maps;
import org.fest.util.Preconditions;
import org.fest.util.Strings;
import org.fest.util.VisibleForTesting;

public class Formatting {
    private static final String MAXIMUM = "maximum";
    private static final String MINIMUM = "minimum";
    private static final String NULL_COMPONENT_MESSAGE = "Null Component";
    private static final String ENABLED = "enabled";
    private static final String NAME = "name";
    private static final String SHOWING = "showing";
    private static final String TEXT = "text";
    private static final String TITLE = "title";
    private static final String VALUE = "value";
    private static final String VISIBLE = "visible";
    private static final ConcurrentMap<Class<?>, ComponentFormatter> FORMATTERS = Maps.newConcurrentHashMap();
    private static Logger logger = Logger.getLogger(Formatting.class.getCanonicalName());

    @Nonnull
    private static ComponentFormatter instrospect(@Nonnull Class<? extends Component> targetType, String ... propertyNames) {
        if (targetType == null) {
            Formatting.$$$reportNull$$$0(0);
        }
        if (propertyNames == null) {
            Formatting.$$$reportNull$$$0(1);
        }
        IntrospectionComponentFormatter introspectionComponentFormatter = new IntrospectionComponentFormatter(targetType, propertyNames);
        if (introspectionComponentFormatter == null) {
            Formatting.$$$reportNull$$$0(2);
        }
        return introspectionComponentFormatter;
    }

    @Nonnull
    private static ComponentFormatter empty(@Nonnull Class<? extends Component> targetType) {
        if (targetType == null) {
            Formatting.$$$reportNull$$$0(3);
        }
        IntrospectionComponentFormatter introspectionComponentFormatter = new IntrospectionComponentFormatter(targetType, new String[0]);
        if (introspectionComponentFormatter == null) {
            Formatting.$$$reportNull$$$0(4);
        }
        return introspectionComponentFormatter;
    }

    @Nonnull
    private static ComponentFormatter nameOnly(@Nonnull Class<? extends Component> targetType) {
        if (targetType == null) {
            Formatting.$$$reportNull$$$0(5);
        }
        IntrospectionComponentFormatter introspectionComponentFormatter = new IntrospectionComponentFormatter(targetType, NAME);
        if (introspectionComponentFormatter == null) {
            Formatting.$$$reportNull$$$0(6);
        }
        return introspectionComponentFormatter;
    }

    public static void register(@Nonnull ComponentFormatter formatter) {
        Class<? extends Component> key;
        ComponentFormatter previous;
        if (formatter == null) {
            Formatting.$$$reportNull$$$0(7);
        }
        if ((previous = FORMATTERS.put(key = formatter.targetType(), formatter)) != null) {
            String format = "Replaced formatter %s with %s for type %s";
            logger.info(String.format(format, previous.toString(), formatter.toString(), key.getName()));
        }
    }

    @VisibleForTesting
    static ComponentFormatter formatter(@Nonnull Class<?> type) {
        if (type == null) {
            Formatting.$$$reportNull$$$0(8);
        }
        return (ComponentFormatter)FORMATTERS.get(type);
    }

    @Nonnull
    @RunsInEDT
    public static String inEdtFormat(final @Nonnull Component c) {
        if (c == null) {
            Formatting.$$$reportNull$$$0(9);
        }
        String result = GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            @Nullable
            protected String executeInEDT() {
                return Formatting.format(c);
            }
        });
        String string = (String)Preconditions.checkNotNull((Object)result);
        if (string == null) {
            Formatting.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nonnull
    @RunsInCurrentThread
    public static String format(@Nullable Component c) {
        if (c == null) {
            if (NULL_COMPONENT_MESSAGE == null) {
                Formatting.$$$reportNull$$$0(11);
            }
            return NULL_COMPONENT_MESSAGE;
        }
        ComponentFormatter formatter = Formatting.formatterFor(c.getClass());
        if (formatter != null) {
            String string = formatter.format(c);
            if (string == null) {
                Formatting.$$$reportNull$$$0(12);
            }
            return string;
        }
        String name = c.getName();
        if (Strings.isNullOrEmpty((String)name)) {
            String string = c.toString();
            if (string == null) {
                Formatting.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = String.format("%s[name=%s]", c.getClass().getName(), name);
        if (string == null) {
            Formatting.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    private static ComponentFormatter formatterFor(@Nonnull Class<?> type) {
        ComponentFormatter formatter;
        if (type == null) {
            Formatting.$$$reportNull$$$0(15);
        }
        if ((formatter = (ComponentFormatter)FORMATTERS.get(type)) != null) {
            return formatter;
        }
        Class<?> superType = type.getSuperclass();
        if (superType != null) {
            return Formatting.formatterFor(superType);
        }
        return null;
    }

    private Formatting() {
    }

    static {
        Formatting.register(Formatting.instrospect(AbstractButton.class, NAME, TEXT, "selected", ENABLED, VISIBLE, SHOWING));
        Formatting.register(Formatting.instrospect(Dialog.class, NAME, TITLE, ENABLED, "modal", VISIBLE, SHOWING));
        Formatting.register(Formatting.instrospect(Frame.class, NAME, TITLE, ENABLED, VISIBLE, SHOWING));
        Formatting.register(new JComboBoxFormatter());
        Formatting.register(Formatting.instrospect(JButton.class, NAME, TEXT, ENABLED, VISIBLE, SHOWING));
        Formatting.register(new JFileChooserFormatter());
        Formatting.register(Formatting.instrospect(JLabel.class, NAME, TEXT, ENABLED, VISIBLE, SHOWING));
        Formatting.register(Formatting.empty(JLayeredPane.class));
        Formatting.register(new JListFormatter());
        Formatting.register(Formatting.empty(JMenuBar.class));
        Formatting.register(new JOptionPaneFormatter());
        Formatting.register(Formatting.nameOnly(JPanel.class));
        Formatting.register(Formatting.instrospect(JPopupMenu.class, NAME, "label", ENABLED, VISIBLE, SHOWING));
        Formatting.register(Formatting.instrospect(JProgressBar.class, NAME, VALUE, MINIMUM, MAXIMUM, "string", "stringPainted", ENABLED, VISIBLE, SHOWING));
        Formatting.register(Formatting.empty(JRootPane.class));
        Formatting.register(Formatting.instrospect(JScrollBar.class, NAME, VALUE, "blockIncrement", MINIMUM, MAXIMUM, ENABLED, VISIBLE, SHOWING));
        Formatting.register(Formatting.instrospect(JScrollPane.class, NAME, ENABLED, VISIBLE, SHOWING));
        Formatting.register(Formatting.instrospect(JSlider.class, NAME, VALUE, MINIMUM, MAXIMUM, ENABLED, VISIBLE, SHOWING));
        Formatting.register(Formatting.instrospect(JSpinner.class, NAME, VALUE, ENABLED, VISIBLE, SHOWING));
        Formatting.register(new JTabbedPaneFormatter());
        Formatting.register(new JTableFormatter());
        Formatting.register(Formatting.nameOnly(JToolBar.class));
        Formatting.register(Formatting.instrospect(JPasswordField.class, NAME, ENABLED, VISIBLE, SHOWING));
        Formatting.register(Formatting.instrospect(JTextComponent.class, NAME, TEXT, ENABLED, VISIBLE, SHOWING));
        Formatting.register(new JTreeFormatter());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyNames";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/format/Formatting";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/format/Formatting";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "instrospect";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "nameOnly";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "inEdtFormat";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "instrospect";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "empty";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "nameOnly";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "formatter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "inEdtFormat";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "formatterFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

