/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Font;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.Assertions;
import org.fest.assertions.BasicDescription;
import org.fest.assertions.BooleanAssert;
import org.fest.assertions.Description;
import org.fest.assertions.IntAssert;
import org.fest.assertions.StringAssert;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

public class FontFixture {
    private static final String PROPERTY_SEPARATOR = " - ";
    private static final String BOLD_PROPERTY = "bold";
    private static final String FAMILY_PROPERTY = "family";
    private static final String ITALIC_PROPERTY = "italic";
    private static final String NAME_PROPERTY = "name";
    private static final String PLAIN_PROPERTY = "plain";
    private static final String SIZE_PROPERTY = "size";
    private final Font target;
    private final Description description;

    public FontFixture(@Nonnull Font target) {
        if (target == null) {
            FontFixture.$$$reportNull$$$0(0);
        }
        this(target, (Description)null);
    }

    public FontFixture(@Nonnull Font target, @Nonnull String description) {
        if (target == null) {
            FontFixture.$$$reportNull$$$0(1);
        }
        if (description == null) {
            FontFixture.$$$reportNull$$$0(2);
        }
        this(target, (Description)new BasicDescription(description));
    }

    public FontFixture(@Nonnull Font target, @Nullable Description description) {
        if (target == null) {
            FontFixture.$$$reportNull$$$0(3);
        }
        this.target = (Font)Preconditions.checkNotNull((Object)target);
        this.description = description;
    }

    @Nonnull
    public FontFixture requireFamily(@Nonnull String family) {
        if (family == null) {
            FontFixture.$$$reportNull$$$0(4);
        }
        ((StringAssert)Assertions.assertThat((String)this.target.getFamily()).as(this.property(FAMILY_PROPERTY))).isEqualTo((Object)family);
        FontFixture fontFixture = this;
        if (fontFixture == null) {
            FontFixture.$$$reportNull$$$0(5);
        }
        return fontFixture;
    }

    @Nonnull
    public FontFixture requireName(@Nonnull String name) {
        if (name == null) {
            FontFixture.$$$reportNull$$$0(6);
        }
        ((StringAssert)Assertions.assertThat((String)this.target.getName()).as(this.property(NAME_PROPERTY))).isEqualTo((Object)name);
        FontFixture fontFixture = this;
        if (fontFixture == null) {
            FontFixture.$$$reportNull$$$0(7);
        }
        return fontFixture;
    }

    @Nonnull
    public FontFixture requireSize(int size) {
        ((IntAssert)Assertions.assertThat((int)this.target.getSize()).as(this.property(SIZE_PROPERTY))).isEqualTo(size);
        FontFixture fontFixture = this;
        if (fontFixture == null) {
            FontFixture.$$$reportNull$$$0(8);
        }
        return fontFixture;
    }

    @Nonnull
    public FontFixture requireBold() {
        FontFixture fontFixture = this.requireBold(true);
        if (fontFixture == null) {
            FontFixture.$$$reportNull$$$0(9);
        }
        return fontFixture;
    }

    @Nonnull
    public FontFixture requireNotBold() {
        FontFixture fontFixture = this.requireBold(false);
        if (fontFixture == null) {
            FontFixture.$$$reportNull$$$0(10);
        }
        return fontFixture;
    }

    @Nonnull
    private FontFixture requireBold(boolean bold) {
        ((BooleanAssert)Assertions.assertThat((boolean)this.target.isBold()).as(this.property(BOLD_PROPERTY))).isEqualTo(bold);
        FontFixture fontFixture = this;
        if (fontFixture == null) {
            FontFixture.$$$reportNull$$$0(11);
        }
        return fontFixture;
    }

    @Nonnull
    public FontFixture requireItalic() {
        FontFixture fontFixture = this.requireItalic(true);
        if (fontFixture == null) {
            FontFixture.$$$reportNull$$$0(12);
        }
        return fontFixture;
    }

    @Nonnull
    public FontFixture requireNotItalic() {
        FontFixture fontFixture = this.requireItalic(false);
        if (fontFixture == null) {
            FontFixture.$$$reportNull$$$0(13);
        }
        return fontFixture;
    }

    @Nonnull
    private FontFixture requireItalic(boolean italic) {
        ((BooleanAssert)Assertions.assertThat((boolean)this.target.isItalic()).as(this.property(ITALIC_PROPERTY))).isEqualTo(italic);
        FontFixture fontFixture = this;
        if (fontFixture == null) {
            FontFixture.$$$reportNull$$$0(14);
        }
        return fontFixture;
    }

    @Nonnull
    public FontFixture requirePlain() {
        FontFixture fontFixture = this.requirePlain(true);
        if (fontFixture == null) {
            FontFixture.$$$reportNull$$$0(15);
        }
        return fontFixture;
    }

    @Nonnull
    public FontFixture requireNotPlain() {
        FontFixture fontFixture = this.requirePlain(false);
        if (fontFixture == null) {
            FontFixture.$$$reportNull$$$0(16);
        }
        return fontFixture;
    }

    @Nonnull
    private FontFixture requirePlain(boolean plain) {
        ((BooleanAssert)Assertions.assertThat((boolean)this.target.isBold()).as(this.property(PLAIN_PROPERTY))).isEqualTo(plain);
        FontFixture fontFixture = this;
        if (fontFixture == null) {
            FontFixture.$$$reportNull$$$0(17);
        }
        return fontFixture;
    }

    @Nonnull
    private String property(@Nonnull String s) {
        if (s == null) {
            FontFixture.$$$reportNull$$$0(18);
        }
        if (!Strings.isNullOrEmpty((String)this.description())) {
            String string = Strings.concat((Object[])new Object[]{this.description.value(), PROPERTY_SEPARATOR, s});
            if (string == null) {
                FontFixture.$$$reportNull$$$0(19);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            FontFixture.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Nonnull
    public Font target() {
        Font font = this.target;
        if (font == null) {
            FontFixture.$$$reportNull$$$0(21);
        }
        return font;
    }

    @Nullable
    public final String description() {
        return this.description != null ? this.description.value() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = FAMILY_PROPERTY;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/fixture/FontFixture";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = NAME_PROPERTY;
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/fixture/FontFixture";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "requireFamily";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "requireName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "requireSize";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "requireBold";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "requireNotBold";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "requireItalic";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "requireNotItalic";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "requirePlain";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "requireNotPlain";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "property";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "requireFamily";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "requireName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "property";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

