/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.ComponentFinder;
import org.fest.swing.core.ComponentFoundCondition;
import org.fest.swing.core.ComponentLookupScope;
import org.fest.swing.core.ComponentMatcher;
import org.fest.swing.core.GenericTypeMatcher;
import org.fest.swing.core.NameMatcher;
import org.fest.swing.core.Robot;
import org.fest.swing.core.TypeMatcher;
import org.fest.swing.driver.ComponentDriver;
import org.fest.swing.fixture.AbstractComponentFixture;
import org.fest.swing.fixture.ComponentContainerFixture;
import org.fest.swing.fixture.ComponentFixtureExtension;
import org.fest.swing.fixture.ContainerFixture;
import org.fest.swing.fixture.DialogFixture;
import org.fest.swing.fixture.JButtonFixture;
import org.fest.swing.fixture.JCheckBoxFixture;
import org.fest.swing.fixture.JComboBoxFixture;
import org.fest.swing.fixture.JFileChooserFixture;
import org.fest.swing.fixture.JLabelFixture;
import org.fest.swing.fixture.JListFixture;
import org.fest.swing.fixture.JMenuItemFinder;
import org.fest.swing.fixture.JMenuItemFixture;
import org.fest.swing.fixture.JOptionPaneFixture;
import org.fest.swing.fixture.JPanelFixture;
import org.fest.swing.fixture.JProgressBarFixture;
import org.fest.swing.fixture.JRadioButtonFixture;
import org.fest.swing.fixture.JScrollBarFixture;
import org.fest.swing.fixture.JScrollPaneFixture;
import org.fest.swing.fixture.JSliderFixture;
import org.fest.swing.fixture.JSpinnerFixture;
import org.fest.swing.fixture.JSplitPaneFixture;
import org.fest.swing.fixture.JTabbedPaneFixture;
import org.fest.swing.fixture.JTableFixture;
import org.fest.swing.fixture.JTextComponentFixture;
import org.fest.swing.fixture.JToggleButtonFixture;
import org.fest.swing.fixture.JToolBarFixture;
import org.fest.swing.fixture.JTreeFixture;
import org.fest.swing.timing.Condition;
import org.fest.swing.timing.Pause;
import org.fest.swing.timing.Timeout;
import org.fest.util.Preconditions;

public abstract class AbstractContainerFixture<S, C extends Container, D extends ComponentDriver>
extends AbstractComponentFixture<S, C, D>
implements ComponentContainerFixture,
ContainerFixture<C> {
    private static final Timeout DEFAULT_DIALOG_LOOKUP_TIMEOUT = Timeout.timeout(100L);
    private final JMenuItemFinder menuItemFinder;

    public AbstractContainerFixture(@Nonnull Class<S> selfType, @Nonnull Robot robot, @Nonnull Class<? extends C> type) {
        if (selfType == null) {
            AbstractContainerFixture.$$$reportNull$$$0(0);
        }
        if (robot == null) {
            AbstractContainerFixture.$$$reportNull$$$0(1);
        }
        if (type == null) {
            AbstractContainerFixture.$$$reportNull$$$0(2);
        }
        super(selfType, robot, type);
        this.menuItemFinder = new JMenuItemFinder(robot, (Container)this.target());
    }

    public AbstractContainerFixture(@Nonnull Class<S> selfType, @Nonnull Robot robot, @Nullable String name, @Nonnull Class<? extends C> type) {
        if (selfType == null) {
            AbstractContainerFixture.$$$reportNull$$$0(3);
        }
        if (robot == null) {
            AbstractContainerFixture.$$$reportNull$$$0(4);
        }
        if (type == null) {
            AbstractContainerFixture.$$$reportNull$$$0(5);
        }
        super(selfType, robot, name, type);
        this.menuItemFinder = new JMenuItemFinder(robot, (Container)this.target());
    }

    public AbstractContainerFixture(@Nonnull Class<S> selfType, @Nonnull Robot robot, @Nonnull C target) {
        if (selfType == null) {
            AbstractContainerFixture.$$$reportNull$$$0(6);
        }
        if (robot == null) {
            AbstractContainerFixture.$$$reportNull$$$0(7);
        }
        if (target == null) {
            AbstractContainerFixture.$$$reportNull$$$0(8);
        }
        super(selfType, robot, target);
        this.menuItemFinder = new JMenuItemFinder(robot, (Container)this.target());
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JButtonFixture button() {
        JButtonFixture jButtonFixture = new JButtonFixture(this.robot(), this.findByType(JButton.class));
        if (jButtonFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(9);
        }
        return jButtonFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JButtonFixture button(@Nonnull GenericTypeMatcher<? extends JButton> matcher) {
        if (matcher == null) {
            AbstractContainerFixture.$$$reportNull$$$0(10);
        }
        JButtonFixture jButtonFixture = new JButtonFixture(this.robot(), this.find(matcher));
        if (jButtonFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(11);
        }
        return jButtonFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JButtonFixture button(@Nullable String name) {
        JButtonFixture jButtonFixture = new JButtonFixture(this.robot(), this.findByName(name, JButton.class));
        if (jButtonFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(12);
        }
        return jButtonFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JCheckBoxFixture checkBox() {
        JCheckBoxFixture jCheckBoxFixture = new JCheckBoxFixture(this.robot(), this.findByType(JCheckBox.class));
        if (jCheckBoxFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(13);
        }
        return jCheckBoxFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JCheckBoxFixture checkBox(@Nonnull GenericTypeMatcher<? extends JCheckBox> matcher) {
        if (matcher == null) {
            AbstractContainerFixture.$$$reportNull$$$0(14);
        }
        JCheckBoxFixture jCheckBoxFixture = new JCheckBoxFixture(this.robot(), this.find(matcher));
        if (jCheckBoxFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(15);
        }
        return jCheckBoxFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JCheckBoxFixture checkBox(@Nullable String name) {
        JCheckBoxFixture jCheckBoxFixture = new JCheckBoxFixture(this.robot(), this.findByName(name, JCheckBox.class));
        if (jCheckBoxFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(16);
        }
        return jCheckBoxFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JComboBoxFixture comboBox() {
        JComboBoxFixture jComboBoxFixture = new JComboBoxFixture(this.robot(), this.findByType(JComboBox.class));
        if (jComboBoxFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(17);
        }
        return jComboBoxFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JComboBoxFixture comboBox(@Nonnull GenericTypeMatcher<? extends JComboBox> matcher) {
        if (matcher == null) {
            AbstractContainerFixture.$$$reportNull$$$0(18);
        }
        JComboBoxFixture jComboBoxFixture = new JComboBoxFixture(this.robot(), this.find(matcher));
        if (jComboBoxFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(19);
        }
        return jComboBoxFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JComboBoxFixture comboBox(@Nullable String name) {
        JComboBoxFixture jComboBoxFixture = new JComboBoxFixture(this.robot(), this.findByName(name, JComboBox.class));
        if (jComboBoxFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(20);
        }
        return jComboBoxFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public DialogFixture dialog() {
        DialogFixture dialogFixture = this.dialog(this.defaultDialogLookupTimeout());
        if (dialogFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(21);
        }
        return dialogFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public DialogFixture dialog(@Nonnull Timeout timeout) {
        if (timeout == null) {
            AbstractContainerFixture.$$$reportNull$$$0(22);
        }
        TypeMatcher matcher = new TypeMatcher(Dialog.class, this.requireShowing());
        DialogFixture dialogFixture = this.findDialog(matcher, timeout);
        if (dialogFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(23);
        }
        return dialogFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public DialogFixture dialog(@Nonnull GenericTypeMatcher<? extends Dialog> matcher) {
        if (matcher == null) {
            AbstractContainerFixture.$$$reportNull$$$0(24);
        }
        DialogFixture dialogFixture = this.dialog(matcher, this.defaultDialogLookupTimeout());
        if (dialogFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(25);
        }
        return dialogFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public DialogFixture dialog(@Nonnull GenericTypeMatcher<? extends Dialog> matcher, @Nonnull Timeout timeout) {
        if (matcher == null) {
            AbstractContainerFixture.$$$reportNull$$$0(26);
        }
        if (timeout == null) {
            AbstractContainerFixture.$$$reportNull$$$0(27);
        }
        DialogFixture dialogFixture = this.findDialog(matcher, timeout);
        if (dialogFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(28);
        }
        return dialogFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public DialogFixture dialog(@Nullable String name) {
        DialogFixture dialogFixture = this.dialog(name, this.defaultDialogLookupTimeout());
        if (dialogFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(29);
        }
        return dialogFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public DialogFixture dialog(@Nullable String name, @Nonnull Timeout timeout) {
        if (timeout == null) {
            AbstractContainerFixture.$$$reportNull$$$0(30);
        }
        NameMatcher matcher = new NameMatcher(name, Dialog.class, this.requireShowing());
        DialogFixture dialogFixture = this.findDialog(matcher, timeout);
        if (dialogFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(31);
        }
        return dialogFixture;
    }

    @Nonnull
    private DialogFixture findDialog(@Nonnull ComponentMatcher matcher, @Nonnull Timeout timeout) {
        if (matcher == null) {
            AbstractContainerFixture.$$$reportNull$$$0(32);
        }
        if (timeout == null) {
            AbstractContainerFixture.$$$reportNull$$$0(33);
        }
        String description = "dialog to be found using matcher " + matcher;
        ComponentFoundCondition condition = new ComponentFoundCondition(description, this.robot().finder(), matcher);
        Pause.pause((Condition)condition, timeout);
        Dialog dialog = (Dialog)condition.found();
        DialogFixture dialogFixture = new DialogFixture(this.robot(), (Dialog)Preconditions.checkNotNull((Object)dialog));
        if (dialogFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(34);
        }
        return dialogFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JFileChooserFixture fileChooser() {
        JFileChooserFixture jFileChooserFixture = this.fileChooser(this.defaultDialogLookupTimeout());
        if (jFileChooserFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(35);
        }
        return jFileChooserFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JFileChooserFixture fileChooser(@Nonnull Timeout timeout) {
        if (timeout == null) {
            AbstractContainerFixture.$$$reportNull$$$0(36);
        }
        TypeMatcher matcher = new TypeMatcher(JFileChooser.class, this.requireShowing());
        JFileChooserFixture jFileChooserFixture = this.findFileChooser(matcher, timeout);
        if (jFileChooserFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(37);
        }
        return jFileChooserFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JFileChooserFixture fileChooser(@Nonnull GenericTypeMatcher<? extends JFileChooser> matcher) {
        if (matcher == null) {
            AbstractContainerFixture.$$$reportNull$$$0(38);
        }
        JFileChooserFixture jFileChooserFixture = this.fileChooser(matcher, this.defaultDialogLookupTimeout());
        if (jFileChooserFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(39);
        }
        return jFileChooserFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JFileChooserFixture fileChooser(@Nonnull GenericTypeMatcher<? extends JFileChooser> matcher, @Nonnull Timeout timeout) {
        if (matcher == null) {
            AbstractContainerFixture.$$$reportNull$$$0(40);
        }
        if (timeout == null) {
            AbstractContainerFixture.$$$reportNull$$$0(41);
        }
        JFileChooserFixture jFileChooserFixture = this.findFileChooser(matcher, timeout);
        if (jFileChooserFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(42);
        }
        return jFileChooserFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JFileChooserFixture fileChooser(@Nullable String name) {
        JFileChooserFixture jFileChooserFixture = new JFileChooserFixture(this.robot(), this.findByName(name, JFileChooser.class));
        if (jFileChooserFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(43);
        }
        return jFileChooserFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JFileChooserFixture fileChooser(@Nullable String name, @Nonnull Timeout timeout) {
        if (timeout == null) {
            AbstractContainerFixture.$$$reportNull$$$0(44);
        }
        NameMatcher matcher = new NameMatcher(name, JFileChooser.class, this.requireShowing());
        JFileChooserFixture jFileChooserFixture = this.findFileChooser(matcher, timeout);
        if (jFileChooserFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(45);
        }
        return jFileChooserFixture;
    }

    @Nonnull
    private JFileChooserFixture findFileChooser(@Nonnull ComponentMatcher matcher, @Nonnull Timeout timeout) {
        if (matcher == null) {
            AbstractContainerFixture.$$$reportNull$$$0(46);
        }
        if (timeout == null) {
            AbstractContainerFixture.$$$reportNull$$$0(47);
        }
        String description = "file chooser to be found using matcher " + matcher;
        ComponentFoundCondition condition = new ComponentFoundCondition(description, this.robot().finder(), matcher);
        Pause.pause((Condition)condition, timeout);
        JFileChooser fileChooser = (JFileChooser)condition.found();
        JFileChooserFixture jFileChooserFixture = new JFileChooserFixture(this.robot(), (JFileChooser)Preconditions.checkNotNull((Object)fileChooser));
        if (jFileChooserFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(48);
        }
        return jFileChooserFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JLabelFixture label() {
        JLabelFixture jLabelFixture = new JLabelFixture(this.robot(), this.findByType(JLabel.class));
        if (jLabelFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(49);
        }
        return jLabelFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JLabelFixture label(@Nonnull GenericTypeMatcher<? extends JLabel> matcher) {
        if (matcher == null) {
            AbstractContainerFixture.$$$reportNull$$$0(50);
        }
        JLabelFixture jLabelFixture = new JLabelFixture(this.robot(), this.find(matcher));
        if (jLabelFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(51);
        }
        return jLabelFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JLabelFixture label(@Nullable String name) {
        JLabelFixture jLabelFixture = new JLabelFixture(this.robot(), this.findByName(name, JLabel.class));
        if (jLabelFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(52);
        }
        return jLabelFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JListFixture list() {
        JListFixture jListFixture = new JListFixture(this.robot(), this.findByType(JList.class));
        if (jListFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(53);
        }
        return jListFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JListFixture list(@Nonnull GenericTypeMatcher<? extends JList> matcher) {
        if (matcher == null) {
            AbstractContainerFixture.$$$reportNull$$$0(54);
        }
        JListFixture jListFixture = new JListFixture(this.robot(), this.find(matcher));
        if (jListFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(55);
        }
        return jListFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JListFixture list(@Nullable String name) {
        JListFixture jListFixture = new JListFixture(this.robot(), this.findByName(name, JList.class));
        if (jListFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(56);
        }
        return jListFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JMenuItemFixture menuItemWithPath(String ... path) {
        if (path == null) {
            AbstractContainerFixture.$$$reportNull$$$0(57);
        }
        JMenuItemFixture jMenuItemFixture = new JMenuItemFixture(this.robot(), this.menuItemFinder.menuItemWithPath(path));
        if (jMenuItemFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(58);
        }
        return jMenuItemFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JMenuItemFixture menuItem(@Nullable String name) {
        boolean requireShowing = ComponentLookupScope.SHOWING_ONLY.equals((Object)this.robot().settings().componentLookupScope());
        JMenuItemFixture jMenuItemFixture = new JMenuItemFixture(this.robot(), this.finder().findByName((Container)this.target(), name, JMenuItem.class, requireShowing));
        if (jMenuItemFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(59);
        }
        return jMenuItemFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JMenuItemFixture menuItem(@Nonnull GenericTypeMatcher<? extends JMenuItem> matcher) {
        if (matcher == null) {
            AbstractContainerFixture.$$$reportNull$$$0(60);
        }
        JMenuItemFixture jMenuItemFixture = new JMenuItemFixture(this.robot(), this.find(matcher));
        if (jMenuItemFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(61);
        }
        return jMenuItemFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JOptionPaneFixture optionPane() {
        JOptionPaneFixture jOptionPaneFixture = this.optionPane(this.defaultDialogLookupTimeout());
        if (jOptionPaneFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(62);
        }
        return jOptionPaneFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JOptionPaneFixture optionPane(@Nonnull Timeout timeout) {
        if (timeout == null) {
            AbstractContainerFixture.$$$reportNull$$$0(63);
        }
        TypeMatcher matcher = new TypeMatcher(JOptionPane.class, this.requireShowing());
        String description = "option pane to be found using matcher " + matcher;
        ComponentFoundCondition condition = new ComponentFoundCondition(description, this.robot().finder(), (ComponentMatcher)matcher);
        Pause.pause((Condition)condition, timeout);
        JOptionPane optionPane = (JOptionPane)condition.found();
        JOptionPaneFixture jOptionPaneFixture = new JOptionPaneFixture(this.robot(), (JOptionPane)Preconditions.checkNotNull((Object)optionPane));
        if (jOptionPaneFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(64);
        }
        return jOptionPaneFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JPanelFixture panel() {
        JPanelFixture jPanelFixture = new JPanelFixture(this.robot(), this.findByType(JPanel.class));
        if (jPanelFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(65);
        }
        return jPanelFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JPanelFixture panel(@Nonnull GenericTypeMatcher<? extends JPanel> matcher) {
        if (matcher == null) {
            AbstractContainerFixture.$$$reportNull$$$0(66);
        }
        JPanelFixture jPanelFixture = new JPanelFixture(this.robot(), this.find(matcher));
        if (jPanelFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(67);
        }
        return jPanelFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JPanelFixture panel(@Nullable String name) {
        JPanelFixture jPanelFixture = new JPanelFixture(this.robot(), this.findByName(name, JPanel.class));
        if (jPanelFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(68);
        }
        return jPanelFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JProgressBarFixture progressBar() {
        JProgressBarFixture jProgressBarFixture = new JProgressBarFixture(this.robot(), this.findByType(JProgressBar.class));
        if (jProgressBarFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(69);
        }
        return jProgressBarFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JProgressBarFixture progressBar(@Nonnull GenericTypeMatcher<? extends JProgressBar> matcher) {
        if (matcher == null) {
            AbstractContainerFixture.$$$reportNull$$$0(70);
        }
        JProgressBarFixture jProgressBarFixture = new JProgressBarFixture(this.robot(), this.find(matcher));
        if (jProgressBarFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(71);
        }
        return jProgressBarFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JProgressBarFixture progressBar(@Nullable String name) {
        JProgressBarFixture jProgressBarFixture = new JProgressBarFixture(this.robot(), this.findByName(name, JProgressBar.class));
        if (jProgressBarFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(72);
        }
        return jProgressBarFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JRadioButtonFixture radioButton() {
        JRadioButtonFixture jRadioButtonFixture = new JRadioButtonFixture(this.robot(), this.findByType(JRadioButton.class));
        if (jRadioButtonFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(73);
        }
        return jRadioButtonFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JRadioButtonFixture radioButton(@Nonnull GenericTypeMatcher<? extends JRadioButton> matcher) {
        if (matcher == null) {
            AbstractContainerFixture.$$$reportNull$$$0(74);
        }
        JRadioButtonFixture jRadioButtonFixture = new JRadioButtonFixture(this.robot(), this.find(matcher));
        if (jRadioButtonFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(75);
        }
        return jRadioButtonFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JRadioButtonFixture radioButton(@Nullable String name) {
        JRadioButtonFixture jRadioButtonFixture = new JRadioButtonFixture(this.robot(), this.findByName(name, JRadioButton.class));
        if (jRadioButtonFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(76);
        }
        return jRadioButtonFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JScrollBarFixture scrollBar() {
        JScrollBarFixture jScrollBarFixture = new JScrollBarFixture(this.robot(), this.findByType(JScrollBar.class));
        if (jScrollBarFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(77);
        }
        return jScrollBarFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JScrollBarFixture scrollBar(@Nonnull GenericTypeMatcher<? extends JScrollBar> matcher) {
        if (matcher == null) {
            AbstractContainerFixture.$$$reportNull$$$0(78);
        }
        JScrollBarFixture jScrollBarFixture = new JScrollBarFixture(this.robot(), this.find(matcher));
        if (jScrollBarFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(79);
        }
        return jScrollBarFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JScrollBarFixture scrollBar(@Nullable String name) {
        JScrollBarFixture jScrollBarFixture = new JScrollBarFixture(this.robot(), this.findByName(name, JScrollBar.class));
        if (jScrollBarFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(80);
        }
        return jScrollBarFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JScrollPaneFixture scrollPane() {
        JScrollPaneFixture jScrollPaneFixture = new JScrollPaneFixture(this.robot(), this.findByType(JScrollPane.class));
        if (jScrollPaneFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(81);
        }
        return jScrollPaneFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JScrollPaneFixture scrollPane(@Nonnull GenericTypeMatcher<? extends JScrollPane> matcher) {
        if (matcher == null) {
            AbstractContainerFixture.$$$reportNull$$$0(82);
        }
        JScrollPaneFixture jScrollPaneFixture = new JScrollPaneFixture(this.robot(), this.find(matcher));
        if (jScrollPaneFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(83);
        }
        return jScrollPaneFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JScrollPaneFixture scrollPane(@Nullable String name) {
        JScrollPaneFixture jScrollPaneFixture = new JScrollPaneFixture(this.robot(), this.findByName(name, JScrollPane.class));
        if (jScrollPaneFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(84);
        }
        return jScrollPaneFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JSliderFixture slider() {
        JSliderFixture jSliderFixture = new JSliderFixture(this.robot(), this.findByType(JSlider.class));
        if (jSliderFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(85);
        }
        return jSliderFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JSliderFixture slider(@Nonnull GenericTypeMatcher<? extends JSlider> matcher) {
        if (matcher == null) {
            AbstractContainerFixture.$$$reportNull$$$0(86);
        }
        JSliderFixture jSliderFixture = new JSliderFixture(this.robot(), this.find(matcher));
        if (jSliderFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(87);
        }
        return jSliderFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JSliderFixture slider(@Nullable String name) {
        JSliderFixture jSliderFixture = new JSliderFixture(this.robot(), this.findByName(name, JSlider.class));
        if (jSliderFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(88);
        }
        return jSliderFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JSpinnerFixture spinner() {
        JSpinnerFixture jSpinnerFixture = new JSpinnerFixture(this.robot(), this.findByType(JSpinner.class));
        if (jSpinnerFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(89);
        }
        return jSpinnerFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JSpinnerFixture spinner(@Nonnull GenericTypeMatcher<? extends JSpinner> matcher) {
        if (matcher == null) {
            AbstractContainerFixture.$$$reportNull$$$0(90);
        }
        JSpinnerFixture jSpinnerFixture = new JSpinnerFixture(this.robot(), this.find(matcher));
        if (jSpinnerFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(91);
        }
        return jSpinnerFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JSpinnerFixture spinner(@Nullable String name) {
        JSpinnerFixture jSpinnerFixture = new JSpinnerFixture(this.robot(), this.findByName(name, JSpinner.class));
        if (jSpinnerFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(92);
        }
        return jSpinnerFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JSplitPaneFixture splitPane() {
        JSplitPaneFixture jSplitPaneFixture = new JSplitPaneFixture(this.robot(), this.findByType(JSplitPane.class));
        if (jSplitPaneFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(93);
        }
        return jSplitPaneFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JSplitPaneFixture splitPane(@Nonnull GenericTypeMatcher<? extends JSplitPane> matcher) {
        if (matcher == null) {
            AbstractContainerFixture.$$$reportNull$$$0(94);
        }
        JSplitPaneFixture jSplitPaneFixture = new JSplitPaneFixture(this.robot(), this.find(matcher));
        if (jSplitPaneFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(95);
        }
        return jSplitPaneFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JSplitPaneFixture splitPane(@Nullable String name) {
        JSplitPaneFixture jSplitPaneFixture = new JSplitPaneFixture(this.robot(), this.findByName(name, JSplitPane.class));
        if (jSplitPaneFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(96);
        }
        return jSplitPaneFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTabbedPaneFixture tabbedPane() {
        JTabbedPaneFixture jTabbedPaneFixture = new JTabbedPaneFixture(this.robot(), this.findByType(JTabbedPane.class));
        if (jTabbedPaneFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(97);
        }
        return jTabbedPaneFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTabbedPaneFixture tabbedPane(@Nonnull GenericTypeMatcher<? extends JTabbedPane> matcher) {
        if (matcher == null) {
            AbstractContainerFixture.$$$reportNull$$$0(98);
        }
        JTabbedPaneFixture jTabbedPaneFixture = new JTabbedPaneFixture(this.robot(), this.find(matcher));
        if (jTabbedPaneFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(99);
        }
        return jTabbedPaneFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTabbedPaneFixture tabbedPane(@Nullable String name) {
        JTabbedPaneFixture jTabbedPaneFixture = new JTabbedPaneFixture(this.robot(), this.findByName(name, JTabbedPane.class));
        if (jTabbedPaneFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(100);
        }
        return jTabbedPaneFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTableFixture table() {
        JTableFixture jTableFixture = new JTableFixture(this.robot(), this.findByType(JTable.class));
        if (jTableFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(101);
        }
        return jTableFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTableFixture table(@Nonnull GenericTypeMatcher<? extends JTable> matcher) {
        if (matcher == null) {
            AbstractContainerFixture.$$$reportNull$$$0(102);
        }
        JTableFixture jTableFixture = new JTableFixture(this.robot(), this.find(matcher));
        if (jTableFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(103);
        }
        return jTableFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTableFixture table(@Nullable String name) {
        JTableFixture jTableFixture = new JTableFixture(this.robot(), this.findByName(name, JTable.class));
        if (jTableFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(104);
        }
        return jTableFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTextComponentFixture textBox() {
        JTextComponentFixture jTextComponentFixture = new JTextComponentFixture(this.robot(), this.findByType(JTextComponent.class));
        if (jTextComponentFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(105);
        }
        return jTextComponentFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTextComponentFixture textBox(@Nonnull GenericTypeMatcher<? extends JTextComponent> matcher) {
        if (matcher == null) {
            AbstractContainerFixture.$$$reportNull$$$0(106);
        }
        JTextComponentFixture jTextComponentFixture = new JTextComponentFixture(this.robot(), this.find(matcher));
        if (jTextComponentFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(107);
        }
        return jTextComponentFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTextComponentFixture textBox(@Nullable String name) {
        JTextComponentFixture jTextComponentFixture = new JTextComponentFixture(this.robot(), this.findByName(name, JTextComponent.class));
        if (jTextComponentFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(108);
        }
        return jTextComponentFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JToggleButtonFixture toggleButton() {
        JToggleButtonFixture jToggleButtonFixture = new JToggleButtonFixture(this.robot(), this.findByType(JToggleButton.class));
        if (jToggleButtonFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(109);
        }
        return jToggleButtonFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JToggleButtonFixture toggleButton(@Nonnull GenericTypeMatcher<? extends JToggleButton> matcher) {
        if (matcher == null) {
            AbstractContainerFixture.$$$reportNull$$$0(110);
        }
        JToggleButtonFixture jToggleButtonFixture = new JToggleButtonFixture(this.robot(), this.find(matcher));
        if (jToggleButtonFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(111);
        }
        return jToggleButtonFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JToggleButtonFixture toggleButton(@Nullable String name) {
        JToggleButtonFixture jToggleButtonFixture = new JToggleButtonFixture(this.robot(), this.findByName(name, JToggleButton.class));
        if (jToggleButtonFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(112);
        }
        return jToggleButtonFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JToolBarFixture toolBar() {
        JToolBarFixture jToolBarFixture = new JToolBarFixture(this.robot(), this.findByType(JToolBar.class));
        if (jToolBarFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(113);
        }
        return jToolBarFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JToolBarFixture toolBar(@Nonnull GenericTypeMatcher<? extends JToolBar> matcher) {
        if (matcher == null) {
            AbstractContainerFixture.$$$reportNull$$$0(114);
        }
        JToolBarFixture jToolBarFixture = new JToolBarFixture(this.robot(), this.find(matcher));
        if (jToolBarFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(115);
        }
        return jToolBarFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JToolBarFixture toolBar(@Nullable String name) {
        JToolBarFixture jToolBarFixture = new JToolBarFixture(this.robot(), this.findByName(name, JToolBar.class));
        if (jToolBarFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(116);
        }
        return jToolBarFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTreeFixture tree() {
        JTreeFixture jTreeFixture = new JTreeFixture(this.robot(), this.findByType(JTree.class));
        if (jTreeFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(117);
        }
        return jTreeFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTreeFixture tree(@Nonnull GenericTypeMatcher<? extends JTree> matcher) {
        if (matcher == null) {
            AbstractContainerFixture.$$$reportNull$$$0(118);
        }
        JTreeFixture jTreeFixture = new JTreeFixture(this.robot(), this.find(matcher));
        if (jTreeFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(119);
        }
        return jTreeFixture;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTreeFixture tree(@Nullable String name) {
        JTreeFixture jTreeFixture = new JTreeFixture(this.robot(), this.findByName(name, JTree.class));
        if (jTreeFixture == null) {
            AbstractContainerFixture.$$$reportNull$$$0(120);
        }
        return jTreeFixture;
    }

    @Nonnull
    protected final <T extends Component> T findByType(@Nonnull Class<T> type) {
        if (type == null) {
            AbstractContainerFixture.$$$reportNull$$$0(121);
        }
        T t = this.finder().findByType((Container)this.target(), type, this.requireShowing());
        if (t == null) {
            AbstractContainerFixture.$$$reportNull$$$0(122);
        }
        return t;
    }

    @Nonnull
    protected final <T extends Component> T findByName(@Nullable String name, @Nonnull Class<T> type) {
        if (type == null) {
            AbstractContainerFixture.$$$reportNull$$$0(123);
        }
        T t = this.finder().findByName((Container)this.target(), name, type, this.requireShowing());
        if (t == null) {
            AbstractContainerFixture.$$$reportNull$$$0(124);
        }
        return t;
    }

    @Nonnull
    protected final <T extends Component> T find(@Nonnull GenericTypeMatcher<? extends T> matcher) {
        if (matcher == null) {
            AbstractContainerFixture.$$$reportNull$$$0(125);
        }
        T t = this.finder().find((Container)this.target(), matcher);
        if (t == null) {
            AbstractContainerFixture.$$$reportNull$$$0(126);
        }
        return t;
    }

    @Nonnull
    @RunsInEDT
    public <T extends Component, F extends AbstractComponentFixture<?, T, ?>> F with(@Nonnull ComponentFixtureExtension<T, F> extension) {
        if (extension == null) {
            AbstractContainerFixture.$$$reportNull$$$0(127);
        }
        F f = extension.createFixture(this.robot(), (Container)this.target());
        if (f == null) {
            AbstractContainerFixture.$$$reportNull$$$0(128);
        }
        return f;
    }

    @Nonnull
    protected final ComponentFinder finder() {
        ComponentFinder componentFinder = this.robot().finder();
        if (componentFinder == null) {
            AbstractContainerFixture.$$$reportNull$$$0(129);
        }
        return componentFinder;
    }

    @Override
    @Nonnull
    public Timeout defaultDialogLookupTimeout() {
        Timeout timeout = DEFAULT_DIALOG_LOOKUP_TIMEOUT;
        if (timeout == null) {
            AbstractContainerFixture.$$$reportNull$$$0(130);
        }
        return timeout;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 129: 
            case 130: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 129: 
            case 130: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selfType";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 2: 
            case 5: 
            case 121: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 129: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/fixture/AbstractContainerFixture";
                break;
            }
            case 10: 
            case 14: 
            case 18: 
            case 24: 
            case 26: 
            case 32: 
            case 38: 
            case 40: 
            case 46: 
            case 50: 
            case 54: 
            case 60: 
            case 66: 
            case 70: 
            case 74: 
            case 78: 
            case 82: 
            case 86: 
            case 90: 
            case 94: 
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: 
            case 118: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 22: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 41: 
            case 44: 
            case 47: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeout";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/fixture/AbstractContainerFixture";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "button";
                break;
            }
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "checkBox";
                break;
            }
            case 17: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "comboBox";
                break;
            }
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "dialog";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "findDialog";
                break;
            }
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 43: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "fileChooser";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "findFileChooser";
                break;
            }
            case 49: 
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "label";
                break;
            }
            case 53: 
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "menuItemWithPath";
                break;
            }
            case 59: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "menuItem";
                break;
            }
            case 62: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "optionPane";
                break;
            }
            case 65: 
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "panel";
                break;
            }
            case 69: 
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "progressBar";
                break;
            }
            case 73: 
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "radioButton";
                break;
            }
            case 77: 
            case 79: 
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "scrollBar";
                break;
            }
            case 81: 
            case 83: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "scrollPane";
                break;
            }
            case 85: 
            case 87: 
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "slider";
                break;
            }
            case 89: 
            case 91: 
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "spinner";
                break;
            }
            case 93: 
            case 95: 
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "splitPane";
                break;
            }
            case 97: 
            case 99: 
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "tabbedPane";
                break;
            }
            case 101: 
            case 103: 
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "table";
                break;
            }
            case 105: 
            case 107: 
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "textBox";
                break;
            }
            case 109: 
            case 111: 
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "toggleButton";
                break;
            }
            case 113: 
            case 115: 
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "toolBar";
                break;
            }
            case 117: 
            case 119: 
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "tree";
                break;
            }
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "findByType";
                break;
            }
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "findByName";
                break;
            }
            case 126: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "with";
                break;
            }
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "finder";
                break;
            }
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultDialogLookupTimeout";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 129: 
            case 130: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "button";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkBox";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "comboBox";
                break;
            }
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "dialog";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findDialog";
                break;
            }
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "fileChooser";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findFileChooser";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "label";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "menuItemWithPath";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "menuItem";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "optionPane";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "panel";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "progressBar";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "radioButton";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "scrollBar";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "scrollPane";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "slider";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "spinner";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "splitPane";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "tabbedPane";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "table";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "textBox";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "toggleButton";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "toolBar";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "tree";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "findByType";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "findByName";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "with";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 129: 
            case 130: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

