/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.edt;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.SwingUtilities;
import org.fest.swing.edt.GuiAction;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.exception.ActionFailedException;
import org.fest.util.Preconditions;

public abstract class GuiQuery<T>
extends GuiAction {
    private T result;

    @Nonnull
    public static <T> T getNonNull(@Nonnull Supplier<T> supplier) {
        if (supplier == null) {
            GuiQuery.$$$reportNull$$$0(0);
        }
        Object object = Preconditions.checkNotNull(GuiActionRunner.execute(GuiQuery.from(supplier)));
        if (object == null) {
            GuiQuery.$$$reportNull$$$0(1);
        }
        return (T)object;
    }

    @Nonnull
    public static <T> GuiQuery<T> from(final @Nonnull Supplier<T> supplier) {
        if (supplier == null) {
            GuiQuery.$$$reportNull$$$0(2);
        }
        GuiQuery guiQuery = new GuiQuery<T>(){

            @Override
            @Nullable
            protected T executeInEDT() throws Throwable {
                return supplier.get();
            }
        };
        if (guiQuery == null) {
            GuiQuery.$$$reportNull$$$0(3);
        }
        return guiQuery;
    }

    @Override
    public final void run() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw ActionFailedException.actionFailure("Query should be executed in the event dispatch thread");
        }
        try {
            this.result = this.executeInEDT();
        }
        catch (Throwable t) {
            this.catchedException(t);
        }
        finally {
            this.notifyExecutionCompleted();
        }
    }

    @Nullable
    protected abstract T executeInEDT() throws Throwable;

    @Nullable
    final T result() {
        return this.result;
    }

    final void clearResult() {
        this.result = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/edt/GuiQuery";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/edt/GuiQuery";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonNull";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "from";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNonNull";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

