/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.Assert;
import org.fest.assertions.AssertExtension;
import org.fest.assertions.Description;
import org.fest.swing.util.Strings;

class TextAssert
extends Assert
implements AssertExtension {
    private final String actual;

    @Nonnull
    static TextAssert assertThat(@Nullable String s) {
        TextAssert textAssert = new TextAssert(s);
        if (textAssert == null) {
            TextAssert.$$$reportNull$$$0(0);
        }
        return textAssert;
    }

    @Nonnull
    static TextAssert verifyThat(@Nullable String s) {
        TextAssert textAssert = new TextAssert(s);
        if (textAssert == null) {
            TextAssert.$$$reportNull$$$0(1);
        }
        return textAssert;
    }

    TextAssert(@Nullable String actual) {
        this.actual = actual;
    }

    @Nonnull
    TextAssert as(@Nullable String description) {
        this.description(description);
        TextAssert textAssert = this;
        if (textAssert == null) {
            TextAssert.$$$reportNull$$$0(2);
        }
        return textAssert;
    }

    @Nonnull
    TextAssert as(@Nullable Description description) {
        this.description(description);
        TextAssert textAssert = this;
        if (textAssert == null) {
            TextAssert.$$$reportNull$$$0(3);
        }
        return textAssert;
    }

    @Nonnull
    TextAssert isEqualOrMatches(@Nullable String s) {
        if (Strings.areEqualOrMatch(s, this.actual)) {
            TextAssert textAssert = this;
            if (textAssert == null) {
                TextAssert.$$$reportNull$$$0(4);
            }
            return textAssert;
        }
        String format = "actual value:<%s> is not equal to or does not match pattern:<%s>";
        String msg = String.format(format, org.fest.util.Strings.quote((String)this.actual), org.fest.util.Strings.quote((String)s));
        throw this.failure(msg);
    }

    @Nonnull
    TextAssert matches(@Nonnull Pattern pattern) {
        if (pattern == null) {
            TextAssert.$$$reportNull$$$0(5);
        }
        if (Strings.match(pattern, this.actual)) {
            TextAssert textAssert = this;
            if (textAssert == null) {
                TextAssert.$$$reportNull$$$0(6);
            }
            return textAssert;
        }
        String format = "actual value:<%s> does not match pattern:<%s>";
        String msg = String.format(format, org.fest.util.Strings.quote((String)this.actual), org.fest.util.Strings.quote((String)pattern.pattern()));
        throw this.failure(msg);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/TextAssert";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "assertThat";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "verifyThat";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "as";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "isEqualOrMatches";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/TextAssert";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "matches";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

