/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.annotation.Nonnull;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.fest.assertions.Description;
import org.fest.assertions.Fail;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.driver.JTreeMatchingPathQuery;
import org.fest.swing.driver.JTreePathFinder;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;
import org.fest.util.Arrays;
import org.fest.util.Objects;
import org.fest.util.Preconditions;

final class JTreeVerifySelectionTask {
    @RunsInEDT
    static void checkHasSelection(final @Nonnull JTree tree, final @Nonnull int[] selection, final @Nonnull Description errMsg) {
        if (tree == null) {
            JTreeVerifySelectionTask.$$$reportNull$$$0(0);
        }
        if (selection == null) {
            JTreeVerifySelectionTask.$$$reportNull$$$0(1);
        }
        if (errMsg == null) {
            JTreeVerifySelectionTask.$$$reportNull$$$0(2);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                JTreeVerifySelectionTask.checkSelection(tree, selection, errMsg);
            }
        });
    }

    @RunsInCurrentThread
    private static void checkSelection(@Nonnull JTree tree, @Nonnull int[] selection, @Nonnull Description errMsg) {
        int[] selectionRows;
        if (tree == null) {
            JTreeVerifySelectionTask.$$$reportNull$$$0(3);
        }
        if (selection == null) {
            JTreeVerifySelectionTask.$$$reportNull$$$0(4);
        }
        if (errMsg == null) {
            JTreeVerifySelectionTask.$$$reportNull$$$0(5);
        }
        if ((selectionRows = tree.getSelectionRows()) == null || selectionRows.length == 0) {
            JTreeVerifySelectionTask.failNoSelection(errMsg);
            return;
        }
        java.util.Arrays.sort(selection);
        if (java.util.Arrays.equals(selectionRows, selection)) {
            return;
        }
        throw JTreeVerifySelectionTask.failNotEqualSelection(errMsg, selection, selectionRows);
    }

    @Nonnull
    private static AssertionError failNotEqualSelection(@Nonnull Description errMsg, @Nonnull int[] expected, @Nonnull int[] actual) {
        if (errMsg == null) {
            JTreeVerifySelectionTask.$$$reportNull$$$0(6);
        }
        if (expected == null) {
            JTreeVerifySelectionTask.$$$reportNull$$$0(7);
        }
        if (actual == null) {
            JTreeVerifySelectionTask.$$$reportNull$$$0(8);
        }
        String format = "[%s] expecting selection:<%s> but was:<%s>";
        String msg = String.format(format, errMsg.value(), Arrays.format((Object)expected), Arrays.format((Object)actual));
        throw Fail.fail((String)msg);
    }

    @RunsInEDT
    static void checkHasSelection(final @Nonnull JTree tree, final @Nonnull String[] selection, final @Nonnull JTreePathFinder pathFinder, final @Nonnull Description errMsg) {
        if (tree == null) {
            JTreeVerifySelectionTask.$$$reportNull$$$0(9);
        }
        if (selection == null) {
            JTreeVerifySelectionTask.$$$reportNull$$$0(10);
        }
        if (pathFinder == null) {
            JTreeVerifySelectionTask.$$$reportNull$$$0(11);
        }
        if (errMsg == null) {
            JTreeVerifySelectionTask.$$$reportNull$$$0(12);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                JTreeVerifySelectionTask.checkSelection(tree, selection, pathFinder, errMsg);
            }
        });
    }

    @RunsInCurrentThread
    private static void checkSelection(@Nonnull JTree tree, @Nonnull String[] selection, @Nonnull JTreePathFinder pathFinder, @Nonnull Description errMsg) {
        TreePath[] selectionPaths;
        if (tree == null) {
            JTreeVerifySelectionTask.$$$reportNull$$$0(13);
        }
        if (selection == null) {
            JTreeVerifySelectionTask.$$$reportNull$$$0(14);
        }
        if (pathFinder == null) {
            JTreeVerifySelectionTask.$$$reportNull$$$0(15);
        }
        if (errMsg == null) {
            JTreeVerifySelectionTask.$$$reportNull$$$0(16);
        }
        if ((selectionPaths = tree.getSelectionPaths()) == null || selectionPaths.length == 0) {
            JTreeVerifySelectionTask.failNoSelection(errMsg);
            return;
        }
        int selectionCount = selection.length;
        if (selectionCount != selectionPaths.length) {
            throw JTreeVerifySelectionTask.failNotEqualSelection(errMsg, selection, selectionPaths);
        }
        for (int i = 0; i < selectionCount; ++i) {
            TreePath actual;
            TreePath expected = JTreeMatchingPathQuery.matchingPathWithRootIfInvisible(tree, (String)Preconditions.checkNotNull((Object)selection[i]), pathFinder);
            if (Objects.areEqual((Object)expected, (Object)(actual = selectionPaths[i]))) continue;
            throw JTreeVerifySelectionTask.failNotEqualSelection(errMsg, selection, selectionPaths);
        }
    }

    @Nonnull
    private static AssertionError failNotEqualSelection(@Nonnull Description errMsg, @Nonnull String[] expected, @Nonnull TreePath[] actual) {
        if (errMsg == null) {
            JTreeVerifySelectionTask.$$$reportNull$$$0(17);
        }
        if (expected == null) {
            JTreeVerifySelectionTask.$$$reportNull$$$0(18);
        }
        if (actual == null) {
            JTreeVerifySelectionTask.$$$reportNull$$$0(19);
        }
        String format = "[%s] expecting selection:<%s> but was:<%s>";
        String msg = String.format(format, errMsg.value(), Arrays.format((Object)expected), Arrays.format((Object)actual));
        throw Fail.fail((String)msg);
    }

    private static void failNoSelection(@Nonnull Description errMessage) {
        if (errMessage == null) {
            JTreeVerifySelectionTask.$$$reportNull$$$0(20);
        }
        Fail.fail((String)String.format("[%s] No selection", errMessage.value()));
    }

    @RunsInEDT
    static void checkNoSelection(final @Nonnull JTree tree, final @Nonnull Description errMsg) {
        if (tree == null) {
            JTreeVerifySelectionTask.$$$reportNull$$$0(21);
        }
        if (errMsg == null) {
            JTreeVerifySelectionTask.$$$reportNull$$$0(22);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                if (tree.getSelectionCount() == 0) {
                    return;
                }
                String format = "[%s] expected no selection but was:<%s>";
                String message = String.format(format, errMsg.value(), Arrays.format((Object)tree.getSelectionPaths()));
                Fail.fail((String)message);
            }
        });
    }

    private JTreeVerifySelectionTask() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 12: 
            case 16: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errMsg";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathFinder";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errMessage";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/driver/JTreeVerifySelectionTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkHasSelection";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSelection";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "failNotEqualSelection";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "failNoSelection";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "checkNoSelection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

