/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import javax.annotation.Nonnull;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.swing.util.Pair;
import org.fest.util.Arrays;

public final class JTreeLocation {
    @Nonnull
    @RunsInCurrentThread
    public Pair<Rectangle, Point> rowBoundsAndCoordinates(@Nonnull JTree tree, int row) {
        Rectangle rowBounds;
        if (tree == null) {
            JTreeLocation.$$$reportNull$$$0(0);
        }
        if ((rowBounds = tree.getRowBounds(this.checkRowInBounds(tree, row))) != null) {
            Pair<Rectangle, Point> pair = Pair.of(rowBounds, this.pointAt(rowBounds));
            if (pair == null) {
                JTreeLocation.$$$reportNull$$$0(1);
            }
            return pair;
        }
        throw new LocationUnavailableException(String.format("The tree row <%d> is not visible", row));
    }

    @Nonnull
    @RunsInCurrentThread
    public TreePath pathFor(@Nonnull JTree tree, int row) {
        TreePath path;
        if (tree == null) {
            JTreeLocation.$$$reportNull$$$0(2);
        }
        if ((path = tree.getPathForRow(this.checkRowInBounds(tree, row))) != null) {
            TreePath treePath = path;
            if (treePath == null) {
                JTreeLocation.$$$reportNull$$$0(3);
            }
            return treePath;
        }
        throw new LocationUnavailableException(String.format("Unable to find tree path for row <%d>", row));
    }

    @RunsInCurrentThread
    public int checkRowInBounds(@Nonnull JTree tree, int row) {
        if (tree == null) {
            JTreeLocation.$$$reportNull$$$0(4);
        }
        int rowCount = tree.getRowCount();
        if (row >= 0 && row < rowCount) {
            return row;
        }
        String msg = String.format("The given row <%d> should be between <0> and <%d>", row, rowCount);
        throw new IndexOutOfBoundsException(msg);
    }

    @Nonnull
    @RunsInCurrentThread
    public Pair<Rectangle, Point> pathBoundsAndCoordinates(@Nonnull JTree tree, @Nonnull TreePath path) {
        Rectangle pathBounds;
        if (tree == null) {
            JTreeLocation.$$$reportNull$$$0(5);
        }
        if (path == null) {
            JTreeLocation.$$$reportNull$$$0(6);
        }
        if ((pathBounds = tree.getPathBounds(path)) != null) {
            Pair<Rectangle, Point> pair = Pair.of(pathBounds, this.pointAt(pathBounds));
            if (pair == null) {
                JTreeLocation.$$$reportNull$$$0(7);
            }
            return pair;
        }
        throw new LocationUnavailableException(String.format("The tree path %s is not visible", Arrays.format((Object)path.getPath())));
    }

    @Nonnull
    private Point pointAt(@Nonnull Rectangle cellBounds) {
        if (cellBounds == null) {
            JTreeLocation.$$$reportNull$$$0(8);
        }
        Point point = new Point(cellBounds.x + cellBounds.width / 2, cellBounds.y + cellBounds.height / 2);
        if (point == null) {
            JTreeLocation.$$$reportNull$$$0(9);
        }
        return point;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JTreeLocation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellBounds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JTreeLocation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "rowBoundsAndCoordinates";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "pathFor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "pathBoundsAndCoordinates";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "pointAt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "rowBoundsAndCoordinates";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "pathFor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkRowInBounds";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "pathBoundsAndCoordinates";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "pointAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

