/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.annotation.Nonnull;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.driver.JTableCellPreconditions;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;
import org.fest.util.Preconditions;

final class JTableStopCellEditingTask {
    @RunsInEDT
    static void stopEditing(final @Nonnull TableCellEditor cellEditor) {
        if (cellEditor == null) {
            JTableStopCellEditingTask.$$$reportNull$$$0(0);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                JTableStopCellEditingTask.doStopCellEditing(cellEditor);
            }
        });
    }

    @RunsInEDT
    static void stopEditing(final @Nonnull JTable table, final int row, final int column) {
        if (table == null) {
            JTableStopCellEditingTask.$$$reportNull$$$0(1);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                JTableStopCellEditingTask.doStopCellEditing(table, row, column);
            }
        });
    }

    @RunsInEDT
    static void checkStateAndStopEditing(final @Nonnull JTable table, final int row, final int column) {
        if (table == null) {
            JTableStopCellEditingTask.$$$reportNull$$$0(2);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                JTableCellPreconditions.checkCellIndicesInBounds(table, row, column);
                JTableCellPreconditions.validateCellIsEditable(table, row, column);
                JTableStopCellEditingTask.doStopCellEditing(table, row, column);
            }
        });
    }

    @RunsInCurrentThread
    private static void doStopCellEditing(@Nonnull JTable table, int row, int column) {
        if (table == null) {
            JTableStopCellEditingTask.$$$reportNull$$$0(3);
        }
        TableCellEditor editor = (TableCellEditor)Preconditions.checkNotNull((Object)table.getCellEditor(row, column));
        JTableStopCellEditingTask.doStopCellEditing(editor);
    }

    @RunsInCurrentThread
    private static void doStopCellEditing(@Nonnull TableCellEditor cellEditor) {
        if (cellEditor == null) {
            JTableStopCellEditingTask.$$$reportNull$$$0(4);
        }
        Preconditions.checkNotNull((Object)cellEditor);
        cellEditor.stopCellEditing();
    }

    private JTableStopCellEditingTask() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellEditor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/driver/JTableStopCellEditingTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "stopEditing";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkStateAndStopEditing";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doStopCellEditing";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

