/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.driver.JTableCellPreconditions;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;

final class JTableCancelCellEditingTask {
    @RunsInEDT
    static void cancelEditing(final @Nonnull JTable table, final int row, final int column) {
        if (table == null) {
            JTableCancelCellEditingTask.$$$reportNull$$$0(0);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                JTableCellPreconditions.checkCellIndicesInBounds(table, row, column);
                JTableCellPreconditions.validateCellIsEditable(table, row, column);
                TableCellEditor cellEditor = table.getCellEditor(row, column);
                JTableCancelCellEditingTask.doCancelEditing(cellEditor);
            }
        });
    }

    @RunsInEDT
    static void cancelEditing(final @Nonnull TableCellEditor cellEditor) {
        if (cellEditor == null) {
            JTableCancelCellEditingTask.$$$reportNull$$$0(1);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                JTableCancelCellEditingTask.doCancelEditing(cellEditor);
            }
        });
    }

    private static void doCancelEditing(@Nullable TableCellEditor cellEditor) {
        if (cellEditor == null) {
            return;
        }
        cellEditor.cancelCellEditing();
    }

    private JTableCancelCellEditingTask() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "table";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "cellEditor";
                break;
            }
        }
        objectArray[1] = "org/fest/swing/driver/JTableCancelCellEditingTask";
        objectArray[2] = "cancelEditing";
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

