/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JTabbedPane;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.driver.JTabbedPaneTabIndexQuery;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.swing.util.StringTextMatcher;
import org.fest.swing.util.TextMatcher;
import org.fest.util.InternalApi;
import org.fest.util.VisibleForTesting;

@InternalApi
public class JTabbedPaneLocation {
    @RunsInCurrentThread
    public int indexOf(@Nonnull JTabbedPane tabbedPane, @Nullable String title) {
        if (tabbedPane == null) {
            JTabbedPaneLocation.$$$reportNull$$$0(0);
        }
        return this.indexOf(tabbedPane, new StringTextMatcher(title));
    }

    @RunsInCurrentThread
    public int indexOf(@Nonnull JTabbedPane tabbedPane, @Nonnull TextMatcher matcher) {
        int index;
        if (tabbedPane == null) {
            JTabbedPaneLocation.$$$reportNull$$$0(1);
        }
        if (matcher == null) {
            JTabbedPaneLocation.$$$reportNull$$$0(2);
        }
        if ((index = JTabbedPaneTabIndexQuery.indexOfTab(tabbedPane, matcher)) >= 0) {
            return index;
        }
        String format = "Unable to find a tab with title matching %s %s";
        String msg = String.format(format, matcher.description(), matcher.formattedValues());
        throw new LocationUnavailableException(msg);
    }

    @Nonnull
    @RunsInCurrentThread
    public Point pointAt(@Nonnull JTabbedPane tabbedPane, int index) {
        if (tabbedPane == null) {
            JTabbedPaneLocation.$$$reportNull$$$0(3);
        }
        this.checkIndexInBounds(tabbedPane, index);
        Rectangle rect = tabbedPane.getUI().getTabBounds(tabbedPane, index);
        if (rect == null || rect.x < 0) {
            String msg = String.format("The tab %d is not visible", index);
            throw new LocationUnavailableException(msg);
        }
        Point point = new Point(rect.x + rect.width / 2, rect.y + rect.height / 2);
        if (point == null) {
            JTabbedPaneLocation.$$$reportNull$$$0(4);
        }
        return point;
    }

    @VisibleForTesting
    @RunsInCurrentThread
    void checkIndexInBounds(JTabbedPane tabbedPane, int index) {
        int max = tabbedPane.getTabCount() - 1;
        if (index >= 0 && index <= max) {
            return;
        }
        String format = "Index <%d> is not within the JTabbedPane bounds of <0> and <%d> (inclusive)";
        String msg = String.format(format, index, max);
        throw new IndexOutOfBoundsException(msg);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabbedPane";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JTabbedPaneLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JTabbedPaneLocation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "pointAt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "pointAt";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

