/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Container;
import java.text.ParseException;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JSpinner;
import javax.swing.text.JTextComponent;
import org.fest.assertions.Assertions;
import org.fest.assertions.ObjectAssert;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.ComponentFinder;
import org.fest.swing.core.Robot;
import org.fest.swing.core.TypeMatcher;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JSpinnerSetValueTask;
import org.fest.swing.driver.JSpinnerValueQuery;
import org.fest.swing.driver.JTextComponentTextQuery;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.format.Formatting;
import org.fest.util.Lists;
import org.fest.util.Strings;

public class JSpinnerDriver
extends JComponentDriver {
    private static final TypeMatcher EDITOR_MATCHER = new TypeMatcher(JTextComponent.class, true);
    private static final String VALUE_PROPERTY = "value";

    public JSpinnerDriver(@Nonnull Robot robot) {
        if (robot == null) {
            JSpinnerDriver.$$$reportNull$$$0(0);
        }
        super(robot);
    }

    @RunsInEDT
    public void increment(@Nonnull JSpinner spinner, int times) {
        if (spinner == null) {
            JSpinnerDriver.$$$reportNull$$$0(1);
        }
        this.checkIsPositive(times, "increment the value");
        JSpinnerDriver.validateAndIncrementValue(spinner, times);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void validateAndIncrementValue(final @Nonnull JSpinner spinner, final int times) {
        if (spinner == null) {
            JSpinnerDriver.$$$reportNull$$$0(2);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(spinner);
                JSpinnerDriver.incrementValue(spinner, times);
            }
        });
    }

    @RunsInCurrentThread
    private static void incrementValue(@Nonnull JSpinner spinner, int times) {
        if (spinner == null) {
            JSpinnerDriver.$$$reportNull$$$0(3);
        }
        for (int i = 0; i < times; ++i) {
            Object newValue = spinner.getNextValue();
            if (newValue == null) {
                return;
            }
            spinner.setValue(newValue);
        }
    }

    @RunsInEDT
    public void increment(@Nonnull JSpinner spinner) {
        if (spinner == null) {
            JSpinnerDriver.$$$reportNull$$$0(4);
        }
        JSpinnerDriver.validateAndIncrementValue(spinner);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void validateAndIncrementValue(final @Nonnull JSpinner spinner) {
        if (spinner == null) {
            JSpinnerDriver.$$$reportNull$$$0(5);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(spinner);
                Object newValue = spinner.getNextValue();
                if (newValue != null) {
                    spinner.setValue(newValue);
                }
            }
        });
    }

    @RunsInEDT
    public void decrement(@Nonnull JSpinner spinner, int times) {
        if (spinner == null) {
            JSpinnerDriver.$$$reportNull$$$0(6);
        }
        this.checkIsPositive(times, "decrement the value");
        JSpinnerDriver.validateAndDecrementValue(spinner, times);
        this.robot.waitForIdle();
    }

    private void checkIsPositive(int times, @Nonnull String action) {
        if (action == null) {
            JSpinnerDriver.$$$reportNull$$$0(7);
        }
        if (times > 0) {
            return;
        }
        String msg = String.format("The number of times to %s should be greater than zero, but was <%d>", action, times);
        throw new IllegalArgumentException(msg);
    }

    @RunsInEDT
    private static void validateAndDecrementValue(final @Nonnull JSpinner spinner, final int times) {
        if (spinner == null) {
            JSpinnerDriver.$$$reportNull$$$0(8);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(spinner);
                JSpinnerDriver.decrementValue(spinner, times);
            }
        });
    }

    @RunsInCurrentThread
    private static void decrementValue(@Nonnull JSpinner spinner, int times) {
        if (spinner == null) {
            JSpinnerDriver.$$$reportNull$$$0(9);
        }
        for (int i = 0; i < times; ++i) {
            Object newValue = spinner.getPreviousValue();
            if (newValue == null) {
                return;
            }
            spinner.setValue(newValue);
        }
    }

    @RunsInEDT
    public void decrement(@Nonnull JSpinner spinner) {
        if (spinner == null) {
            JSpinnerDriver.$$$reportNull$$$0(10);
        }
        JSpinnerDriver.validateAndDecrementValue(spinner);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void validateAndDecrementValue(final @Nonnull JSpinner spinner) {
        if (spinner == null) {
            JSpinnerDriver.$$$reportNull$$$0(11);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(spinner);
                Object newValue = spinner.getPreviousValue();
                if (newValue != null) {
                    spinner.setValue(newValue);
                }
            }
        });
    }

    @Nullable
    @RunsInEDT
    public String textOf(@Nonnull JSpinner spinner) {
        JTextComponent editor;
        if (spinner == null) {
            JSpinnerDriver.$$$reportNull$$$0(12);
        }
        if ((editor = this.findEditor(spinner)) != null) {
            return JTextComponentTextQuery.textOf(editor);
        }
        Object value = JSpinnerValueQuery.valueOf(spinner);
        return value != null ? value.toString() : null;
    }

    @RunsInEDT
    public void enterTextAndCommit(@Nonnull JSpinner spinner, String text) {
        if (spinner == null) {
            JSpinnerDriver.$$$reportNull$$$0(13);
        }
        this.enterText(spinner, text);
        JSpinnerDriver.commit(spinner);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void commit(final @Nonnull JSpinner spinner) {
        if (spinner == null) {
            JSpinnerDriver.$$$reportNull$$$0(14);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws ParseException {
                spinner.commitEdit();
            }
        });
    }

    @RunsInEDT
    public void enterText(@Nonnull JSpinner spinner, @Nonnull String text) {
        if (spinner == null) {
            JSpinnerDriver.$$$reportNull$$$0(15);
        }
        if (text == null) {
            JSpinnerDriver.$$$reportNull$$$0(16);
        }
        JSpinnerDriver.checkInEdtEnabledAndShowing(spinner);
        JTextComponent editor = this.findEditor(spinner);
        this.robot.waitForIdle();
        JSpinnerDriver.checkEditorNotNull(spinner, editor);
        if (editor == null) {
            return;
        }
        this.robot.focusAndWaitForFocusGain(editor);
        this.invokeAction(editor, "select-all");
        this.robot.enterText(text);
    }

    @Nullable
    @RunsInEDT
    private JTextComponent findEditor(@Nonnull JSpinner spinner) {
        ComponentFinder finder;
        ArrayList found;
        if (spinner == null) {
            JSpinnerDriver.$$$reportNull$$$0(17);
        }
        if ((found = Lists.newArrayList((finder = this.robot.finder()).findAll((Container)spinner, EDITOR_MATCHER))).size() != 1) {
            return null;
        }
        Component c = (Component)found.get(0);
        if (c instanceof JTextComponent) {
            return (JTextComponent)c;
        }
        return null;
    }

    @RunsInEDT
    private static void checkEditorNotNull(final @Nonnull JSpinner spinner, final @Nullable JTextComponent editor) {
        if (spinner == null) {
            JSpinnerDriver.$$$reportNull$$$0(18);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                if (editor == null) {
                    throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Unable to find editor for ", Formatting.format(spinner)}));
                }
            }
        });
    }

    @RunsInEDT
    public void selectValue(@Nonnull JSpinner spinner, @Nonnull Object value) {
        if (spinner == null) {
            JSpinnerDriver.$$$reportNull$$$0(19);
        }
        if (value == null) {
            JSpinnerDriver.$$$reportNull$$$0(20);
        }
        try {
            JSpinnerSetValueTask.setValue(spinner, value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(Strings.concat((Object[])new Object[]{"Value ", Strings.quote((Object)value), " is not valid"}));
        }
        this.robot.waitForIdle();
    }

    @RunsInEDT
    public JTextComponent editor(@Nonnull JSpinner spinner) {
        if (spinner == null) {
            JSpinnerDriver.$$$reportNull$$$0(21);
        }
        return (JTextComponent)this.robot.finder().find((Container)spinner, EDITOR_MATCHER);
    }

    @RunsInEDT
    public void requireValue(@Nonnull JSpinner spinner, Object value) {
        if (spinner == null) {
            JSpinnerDriver.$$$reportNull$$$0(22);
        }
        ((ObjectAssert)Assertions.assertThat((Object)JSpinnerValueQuery.valueOf(spinner)).as(JSpinnerDriver.propertyName(spinner, VALUE_PROPERTY))).isEqualTo(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spinner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = VALUE_PROPERTY;
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/driver/JSpinnerDriver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "increment";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "validateAndIncrementValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "incrementValue";
                break;
            }
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "decrement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIsPositive";
                break;
            }
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "validateAndDecrementValue";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "decrementValue";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "textOf";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "enterTextAndCommit";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "commit";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "enterText";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "findEditor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "checkEditorNotNull";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "selectValue";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "editor";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "requireValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

