/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.swing.JScrollBar;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.driver.HorizontalJScrollBarLocation;
import org.fest.swing.driver.JScrollBarLocationStrategy;
import org.fest.swing.driver.VerticalJScrollBarLocation;
import org.fest.util.Maps;
import org.fest.util.Preconditions;

public final class JScrollBarLocation {
    private static final int BLOCK_OFFSET = 4;
    private static final Map<Integer, JScrollBarLocationStrategy> LOCATIONS = Maps.newHashMap();

    @Nonnull
    @RunsInCurrentThread
    public Point thumbLocation(@Nonnull JScrollBar scrollBar, int position) {
        if (scrollBar == null) {
            JScrollBarLocation.$$$reportNull$$$0(0);
        }
        double fraction = (double)position / (double)this.maximumMinusMinimum(scrollBar);
        Point point = this.locationStrategyFor(scrollBar).thumbLocation(scrollBar, fraction);
        if (point == null) {
            JScrollBarLocation.$$$reportNull$$$0(1);
        }
        return point;
    }

    @RunsInCurrentThread
    private int maximumMinusMinimum(@Nonnull JScrollBar scrollBar) {
        if (scrollBar == null) {
            JScrollBarLocation.$$$reportNull$$$0(2);
        }
        return scrollBar.getMaximum() - scrollBar.getMinimum();
    }

    @Nonnull
    @RunsInCurrentThread
    public Point blockLocationToScrollUp(@Nonnull JScrollBar scrollBar) {
        if (scrollBar == null) {
            JScrollBarLocation.$$$reportNull$$$0(3);
        }
        Point p = this.unitLocationToScrollUp(scrollBar);
        int offset = 4;
        Point point = this.blockLocation(scrollBar, p, offset);
        if (point == null) {
            JScrollBarLocation.$$$reportNull$$$0(4);
        }
        return point;
    }

    @Nonnull
    @RunsInCurrentThread
    public Point blockLocationToScrollDown(@Nonnull JScrollBar scrollBar) {
        if (scrollBar == null) {
            JScrollBarLocation.$$$reportNull$$$0(5);
        }
        Point p = this.unitLocationToScrollDown(scrollBar);
        int offset = -4;
        Point point = this.blockLocation(scrollBar, p, offset);
        if (point == null) {
            JScrollBarLocation.$$$reportNull$$$0(6);
        }
        return point;
    }

    @Nonnull
    @RunsInCurrentThread
    private Point blockLocation(@Nonnull JScrollBar scrollBar, @Nonnull Point unitLocation, int offset) {
        if (scrollBar == null) {
            JScrollBarLocation.$$$reportNull$$$0(7);
        }
        if (unitLocation == null) {
            JScrollBarLocation.$$$reportNull$$$0(8);
        }
        Point point = this.locationStrategyFor(scrollBar).blockLocation(scrollBar, unitLocation, offset);
        if (point == null) {
            JScrollBarLocation.$$$reportNull$$$0(9);
        }
        return point;
    }

    @Nonnull
    @RunsInCurrentThread
    public Point unitLocationToScrollUp(@Nonnull JScrollBar scrollBar) {
        if (scrollBar == null) {
            JScrollBarLocation.$$$reportNull$$$0(10);
        }
        int arrow = this.locationStrategyFor(scrollBar).arrow(scrollBar);
        Point point = new Point(arrow / 2, arrow / 2);
        if (point == null) {
            JScrollBarLocation.$$$reportNull$$$0(11);
        }
        return point;
    }

    @Nonnull
    @RunsInCurrentThread
    public Point unitLocationToScrollDown(@Nonnull JScrollBar scrollBar) {
        if (scrollBar == null) {
            JScrollBarLocation.$$$reportNull$$$0(12);
        }
        Point point = this.locationStrategyFor(scrollBar).unitLocationToScrollDown(scrollBar);
        if (point == null) {
            JScrollBarLocation.$$$reportNull$$$0(13);
        }
        return point;
    }

    @Nonnull
    @RunsInCurrentThread
    private JScrollBarLocationStrategy locationStrategyFor(JScrollBar scrollBar) {
        JScrollBarLocationStrategy strategy = LOCATIONS.get(scrollBar.getOrientation());
        JScrollBarLocationStrategy jScrollBarLocationStrategy = (JScrollBarLocationStrategy)Preconditions.checkNotNull((Object)strategy);
        if (jScrollBarLocationStrategy == null) {
            JScrollBarLocation.$$$reportNull$$$0(14);
        }
        return jScrollBarLocationStrategy;
    }

    static {
        LOCATIONS.put(0, new HorizontalJScrollBarLocation());
        LOCATIONS.put(1, new VerticalJScrollBarLocation());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollBar";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JScrollBarLocation";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JScrollBarLocation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "thumbLocation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "blockLocationToScrollUp";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "blockLocationToScrollDown";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "blockLocation";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "unitLocationToScrollUp";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "unitLocationToScrollDown";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "locationStrategyFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "thumbLocation";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "maximumMinusMinimum";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "blockLocationToScrollUp";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "blockLocationToScrollDown";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "blockLocation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unitLocationToScrollUp";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "unitLocationToScrollDown";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

