/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.annotation.Nonnull;
import javax.swing.JProgressBar;
import org.fest.assertions.Description;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.driver.JProgressBarIndeterminateQuery;
import org.fest.swing.edt.GuiLazyLoadingDescription;
import org.fest.swing.format.Formatting;
import org.fest.swing.timing.Condition;
import org.fest.swing.timing.Pause;
import org.fest.swing.timing.Timeout;

final class JProgressBarWaitUntilIsDeterminate {
    @RunsInEDT
    static void waitUntilValueIsDeterminate(final @Nonnull JProgressBar progressBar, @Nonnull Timeout timeout) {
        if (progressBar == null) {
            JProgressBarWaitUntilIsDeterminate.$$$reportNull$$$0(0);
        }
        if (timeout == null) {
            JProgressBarWaitUntilIsDeterminate.$$$reportNull$$$0(1);
        }
        Pause.pause(new Condition(JProgressBarWaitUntilIsDeterminate.untilIsDeterminate(progressBar)){

            @Override
            public boolean test() {
                return !JProgressBarIndeterminateQuery.isIndeterminate(progressBar);
            }
        }, timeout);
    }

    private static Description untilIsDeterminate(final @Nonnull JProgressBar progressBar) {
        if (progressBar == null) {
            JProgressBarWaitUntilIsDeterminate.$$$reportNull$$$0(2);
        }
        return new GuiLazyLoadingDescription(){

            @Override
            @Nonnull
            protected String loadDescription() {
                String string = Formatting.format(progressBar) + " to be in determinate mode";
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", "org/fest/swing/driver/JProgressBarWaitUntilIsDeterminate$2", "loadDescription"));
            }
        };
    }

    private JProgressBarWaitUntilIsDeterminate() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressBar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeout";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/driver/JProgressBarWaitUntilIsDeterminate";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "waitUntilValueIsDeterminate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "untilIsDeterminate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

