/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.driver.MenuElementComponentQuery;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.util.Preconditions;

final class JPopupMenuElementsAsTextQuery {
    @Nonnull
    @RunsInEDT
    static String[] menuElementsAsText(final @Nonnull JPopupMenu popupMenu) {
        if (popupMenu == null) {
            JPopupMenuElementsAsTextQuery.$$$reportNull$$$0(0);
        }
        String[] result = GuiActionRunner.execute(new GuiQuery<String[]>(){

            @Override
            protected String[] executeInEDT() throws Throwable {
                MenuElement[] subElements = popupMenu.getSubElements();
                String[] result = new String[subElements.length];
                for (int i = 0; i < subElements.length; ++i) {
                    MenuElement subElement = (MenuElement)Preconditions.checkNotNull((Object)subElements[i]);
                    result[i] = JPopupMenuElementsAsTextQuery.textOf(subElement);
                }
                return result;
            }
        });
        String[] stringArray = (String[])Preconditions.checkNotNull((Object)result);
        if (stringArray == null) {
            JPopupMenuElementsAsTextQuery.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    @Nullable
    private static String textOf(@Nonnull MenuElement e) {
        Component c;
        if (e == null) {
            JPopupMenuElementsAsTextQuery.$$$reportNull$$$0(2);
        }
        if ((c = MenuElementComponentQuery.componentIn(e)) instanceof JMenuItem) {
            return ((JMenuItem)c).getText();
        }
        return "-";
    }

    private JPopupMenuElementsAsTextQuery() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupMenu";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JPopupMenuElementsAsTextQuery";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JPopupMenuElementsAsTextQuery";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "menuElementsAsText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "menuElementsAsText";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "textOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

