/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Container;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.fest.assertions.Assertions;
import org.fest.assertions.Description;
import org.fest.assertions.ObjectArrayAssert;
import org.fest.assertions.ObjectAssert;
import org.fest.assertions.StringAssert;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.core.matcher.JButtonMatcher;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JOptionPaneMessageQuery;
import org.fest.swing.driver.JOptionPaneMessageTypeQuery;
import org.fest.swing.driver.JOptionPaneMessageTypes;
import org.fest.swing.driver.JOptionPaneOptionsQuery;
import org.fest.swing.driver.JOptionPaneTitleQuery;
import org.fest.swing.driver.TextAssert;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

@InternalApi
public class JOptionPaneDriver
extends JComponentDriver {
    private static final String MESSAGE_PROPERTY = "message";
    private static final String MESSAGE_TYPE_PROPERTY = "messageType";
    private static final String OPTIONS_PROPERTY = "options";
    private static final String TITLE_PROPERTY = "title";

    public JOptionPaneDriver(@Nonnull Robot robot) {
        if (robot == null) {
            JOptionPaneDriver.$$$reportNull$$$0(0);
        }
        super(robot);
    }

    @RunsInEDT
    public void requireTitle(@Nonnull JOptionPane optionPane, @Nullable String title) {
        if (optionPane == null) {
            JOptionPaneDriver.$$$reportNull$$$0(1);
        }
        TextAssert.verifyThat(this.title(optionPane)).as(JOptionPaneDriver.propertyName(optionPane, TITLE_PROPERTY)).isEqualOrMatches(title);
    }

    @RunsInEDT
    public void requireTitle(@Nonnull JOptionPane optionPane, @Nonnull Pattern pattern) {
        if (optionPane == null) {
            JOptionPaneDriver.$$$reportNull$$$0(2);
        }
        if (pattern == null) {
            JOptionPaneDriver.$$$reportNull$$$0(3);
        }
        TextAssert.verifyThat(this.title(optionPane)).as(JOptionPaneDriver.propertyName(optionPane, TITLE_PROPERTY)).matches(pattern);
    }

    @Nullable
    @RunsInEDT
    public String title(@Nonnull JOptionPane optionPane) {
        if (optionPane == null) {
            JOptionPaneDriver.$$$reportNull$$$0(4);
        }
        return JOptionPaneTitleQuery.titleOf(optionPane);
    }

    @RunsInEDT
    public void requireMessage(@Nonnull JOptionPane optionPane, @Nullable Object message) {
        if (optionPane == null) {
            JOptionPaneDriver.$$$reportNull$$$0(5);
        }
        Object actual = JOptionPaneMessageQuery.messageOf(optionPane);
        if (message instanceof String && actual != null) {
            this.requireMessage(optionPane, (String)message, actual.toString());
            return;
        }
        ((ObjectAssert)Assertions.assertThat((Object)actual).as(this.messageProperty(optionPane))).isEqualTo(message);
    }

    @RunsInEDT
    private void requireMessage(@Nonnull JOptionPane optionPane, @Nullable String expected, @Nullable String actual) {
        if (optionPane == null) {
            JOptionPaneDriver.$$$reportNull$$$0(6);
        }
        TextAssert.verifyThat(actual).as(this.messageProperty(optionPane)).isEqualOrMatches(expected);
    }

    @RunsInEDT
    public void requireMessage(@Nonnull JOptionPane optionPane, @Nonnull Pattern pattern) {
        Object actual;
        if (optionPane == null) {
            JOptionPaneDriver.$$$reportNull$$$0(7);
        }
        if (pattern == null) {
            JOptionPaneDriver.$$$reportNull$$$0(8);
        }
        String s = (actual = JOptionPaneMessageQuery.messageOf(optionPane)) == null ? null : actual.toString();
        TextAssert.verifyThat(s).as(this.messageProperty(optionPane)).matches(pattern);
    }

    private Description messageProperty(@Nonnull JOptionPane optionPane) {
        if (optionPane == null) {
            JOptionPaneDriver.$$$reportNull$$$0(9);
        }
        return JOptionPaneDriver.propertyName(optionPane, MESSAGE_PROPERTY);
    }

    @RunsInEDT
    public void requireOptions(@Nonnull JOptionPane optionPane, @Nonnull Object[] options) {
        if (optionPane == null) {
            JOptionPaneDriver.$$$reportNull$$$0(10);
        }
        if (options == null) {
            JOptionPaneDriver.$$$reportNull$$$0(11);
        }
        ((ObjectArrayAssert)Assertions.assertThat((Object[])JOptionPaneOptionsQuery.optionsOf(optionPane)).as(JOptionPaneDriver.propertyName(optionPane, OPTIONS_PROPERTY))).isEqualTo(options);
    }

    @Nonnull
    @RunsInEDT
    public JButton okButton(@Nonnull JOptionPane optionPane) {
        if (optionPane == null) {
            JOptionPaneDriver.$$$reportNull$$$0(12);
        }
        JButton jButton = this.buttonWithTextFromUIManager(optionPane, "OptionPane.okButtonText");
        if (jButton == null) {
            JOptionPaneDriver.$$$reportNull$$$0(13);
        }
        return jButton;
    }

    @Nonnull
    @RunsInEDT
    public JButton cancelButton(@Nonnull JOptionPane optionPane) {
        if (optionPane == null) {
            JOptionPaneDriver.$$$reportNull$$$0(14);
        }
        JButton jButton = this.buttonWithTextFromUIManager(optionPane, "OptionPane.cancelButtonText");
        if (jButton == null) {
            JOptionPaneDriver.$$$reportNull$$$0(15);
        }
        return jButton;
    }

    @Nonnull
    @RunsInEDT
    public JButton yesButton(@Nonnull JOptionPane optionPane) {
        if (optionPane == null) {
            JOptionPaneDriver.$$$reportNull$$$0(16);
        }
        JButton jButton = this.buttonWithTextFromUIManager(optionPane, "OptionPane.yesButtonText");
        if (jButton == null) {
            JOptionPaneDriver.$$$reportNull$$$0(17);
        }
        return jButton;
    }

    @Nonnull
    @RunsInEDT
    public JButton noButton(@Nonnull JOptionPane optionPane) {
        if (optionPane == null) {
            JOptionPaneDriver.$$$reportNull$$$0(18);
        }
        JButton jButton = this.buttonWithTextFromUIManager(optionPane, "OptionPane.noButtonText");
        if (jButton == null) {
            JOptionPaneDriver.$$$reportNull$$$0(19);
        }
        return jButton;
    }

    @Nonnull
    @RunsInEDT
    private JButton buttonWithTextFromUIManager(@Nonnull JOptionPane optionPane, @Nonnull String key) {
        if (optionPane == null) {
            JOptionPaneDriver.$$$reportNull$$$0(20);
        }
        if (key == null) {
            JOptionPaneDriver.$$$reportNull$$$0(21);
        }
        JButton jButton = this.buttonWithText(optionPane, (String)Preconditions.checkNotNull((Object)UIManager.getString(key)));
        if (jButton == null) {
            JOptionPaneDriver.$$$reportNull$$$0(22);
        }
        return jButton;
    }

    @Nonnull
    @RunsInEDT
    public JButton buttonWithText(@Nonnull JOptionPane optionPane, @Nullable String text) {
        if (optionPane == null) {
            JOptionPaneDriver.$$$reportNull$$$0(23);
        }
        JButton jButton = this.robot.finder().find((Container)optionPane, JButtonMatcher.withText(text).andShowing());
        if (jButton == null) {
            JOptionPaneDriver.$$$reportNull$$$0(24);
        }
        return jButton;
    }

    @Nonnull
    @RunsInEDT
    public JButton buttonWithText(@Nonnull JOptionPane optionPane, @Nonnull Pattern pattern) {
        if (optionPane == null) {
            JOptionPaneDriver.$$$reportNull$$$0(25);
        }
        if (pattern == null) {
            JOptionPaneDriver.$$$reportNull$$$0(26);
        }
        JButton jButton = this.robot.finder().find((Container)optionPane, JButtonMatcher.withText(pattern).andShowing());
        if (jButton == null) {
            JOptionPaneDriver.$$$reportNull$$$0(27);
        }
        return jButton;
    }

    @RunsInEDT
    public void requireErrorMessage(@Nonnull JOptionPane optionPane) {
        if (optionPane == null) {
            JOptionPaneDriver.$$$reportNull$$$0(28);
        }
        this.assertEqualMessageType(optionPane, 0);
    }

    @RunsInEDT
    public void requireInformationMessage(@Nonnull JOptionPane optionPane) {
        if (optionPane == null) {
            JOptionPaneDriver.$$$reportNull$$$0(29);
        }
        this.assertEqualMessageType(optionPane, 1);
    }

    @RunsInEDT
    public void requireWarningMessage(@Nonnull JOptionPane optionPane) {
        if (optionPane == null) {
            JOptionPaneDriver.$$$reportNull$$$0(30);
        }
        this.assertEqualMessageType(optionPane, 2);
    }

    @RunsInEDT
    public void requireQuestionMessage(@Nonnull JOptionPane optionPane) {
        if (optionPane == null) {
            JOptionPaneDriver.$$$reportNull$$$0(31);
        }
        this.assertEqualMessageType(optionPane, 3);
    }

    @RunsInEDT
    public void requirePlainMessage(@Nonnull JOptionPane optionPane) {
        if (optionPane == null) {
            JOptionPaneDriver.$$$reportNull$$$0(32);
        }
        this.assertEqualMessageType(optionPane, -1);
    }

    @RunsInEDT
    private void assertEqualMessageType(@Nonnull JOptionPane optionPane, int expected) {
        if (optionPane == null) {
            JOptionPaneDriver.$$$reportNull$$$0(33);
        }
        String actualType = this.actualMessageTypeAsText(optionPane);
        ((StringAssert)Assertions.assertThat((String)actualType).as(JOptionPaneDriver.propertyName(optionPane, MESSAGE_TYPE_PROPERTY))).isEqualTo((Object)JOptionPaneMessageTypes.messageTypeAsText(expected));
    }

    @RunsInEDT
    private String actualMessageTypeAsText(@Nonnull JOptionPane optionPane) {
        if (optionPane == null) {
            JOptionPaneDriver.$$$reportNull$$$0(34);
        }
        return JOptionPaneMessageTypes.messageTypeAsText(JOptionPaneMessageTypeQuery.messageTypeOf(optionPane));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 24: 
            case 27: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 24: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionPane";
                break;
            }
            case 3: 
            case 8: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = OPTIONS_PROPERTY;
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JOptionPaneDriver";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JOptionPaneDriver";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "okButton";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "cancelButton";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "yesButton";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "noButton";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "buttonWithTextFromUIManager";
                break;
            }
            case 24: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "buttonWithText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "requireTitle";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = TITLE_PROPERTY;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "requireMessage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "messageProperty";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "requireOptions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "okButton";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 24: 
            case 27: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "cancelButton";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "yesButton";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "noButton";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "buttonWithTextFromUIManager";
                break;
            }
            case 23: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "buttonWithText";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "requireErrorMessage";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "requireInformationMessage";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "requireWarningMessage";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "requireQuestionMessage";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "requirePlainMessage";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "assertEqualMessageType";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "actualMessageTypeAsText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 24: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

