/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JList;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JListCellReader;
import org.fest.swing.driver.JListCellBoundsQuery;
import org.fest.swing.driver.JListCellCenterQuery;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.util.StringTextMatcher;
import org.fest.swing.util.TextMatcher;
import org.fest.util.Lists;
import org.fest.util.Preconditions;
import org.fest.util.Sets;

final class JListMatchingItemQuery {
    @Nonnull
    @RunsInEDT
    static Point centerOfMatchingItemCell(final @Nonnull JList list, final @Nullable String value, final @Nonnull JListCellReader cellReader) {
        if (list == null) {
            JListMatchingItemQuery.$$$reportNull$$$0(0);
        }
        if (cellReader == null) {
            JListMatchingItemQuery.$$$reportNull$$$0(1);
        }
        Point result = GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                int itemIndex = JListMatchingItemQuery.matchingItemIndex(list, new StringTextMatcher(value), cellReader);
                Rectangle cellBounds = (Rectangle)Preconditions.checkNotNull((Object)JListCellBoundsQuery.cellBounds(list, itemIndex));
                return JListCellCenterQuery.cellCenter(list, cellBounds);
            }
        });
        Point point = (Point)Preconditions.checkNotNull((Object)result);
        if (point == null) {
            JListMatchingItemQuery.$$$reportNull$$$0(2);
        }
        return point;
    }

    @RunsInCurrentThread
    static int matchingItemIndex(@Nonnull JList list, @Nonnull TextMatcher matcher, @Nonnull JListCellReader cellReader) {
        if (list == null) {
            JListMatchingItemQuery.$$$reportNull$$$0(3);
        }
        if (matcher == null) {
            JListMatchingItemQuery.$$$reportNull$$$0(4);
        }
        if (cellReader == null) {
            JListMatchingItemQuery.$$$reportNull$$$0(5);
        }
        int size = list.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            if (!matcher.isMatching(cellReader.valueAt(list, i))) continue;
            return i;
        }
        return -1;
    }

    @Nonnull
    @RunsInEDT
    static List<Integer> matchingItemIndices(final @Nonnull JList list, final @Nonnull TextMatcher matcher, final @Nonnull JListCellReader cellReader) {
        if (list == null) {
            JListMatchingItemQuery.$$$reportNull$$$0(6);
        }
        if (matcher == null) {
            JListMatchingItemQuery.$$$reportNull$$$0(7);
        }
        if (cellReader == null) {
            JListMatchingItemQuery.$$$reportNull$$$0(8);
        }
        List<Integer> result = GuiActionRunner.execute(new GuiQuery<List<Integer>>(){

            @Override
            protected List<Integer> executeInEDT() {
                HashSet indices = Sets.newHashSet();
                int size = list.getModel().getSize();
                for (int i = 0; i < size; ++i) {
                    if (!matcher.isMatching(cellReader.valueAt(list, i))) continue;
                    indices.add(i);
                }
                ArrayList indexList = Lists.newArrayList((Iterable)indices);
                Collections.sort(indexList);
                return indexList;
            }
        });
        List list2 = (List)Preconditions.checkNotNull(result);
        if (list2 == null) {
            JListMatchingItemQuery.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @Nonnull
    @RunsInEDT
    static List<String> matchingItemValues(final @Nonnull JList list, final @Nonnull TextMatcher matcher, final @Nonnull JListCellReader cellReader) {
        if (list == null) {
            JListMatchingItemQuery.$$$reportNull$$$0(10);
        }
        if (matcher == null) {
            JListMatchingItemQuery.$$$reportNull$$$0(11);
        }
        if (cellReader == null) {
            JListMatchingItemQuery.$$$reportNull$$$0(12);
        }
        List<String> result = GuiActionRunner.execute(new GuiQuery<List<String>>(){

            @Override
            protected List<String> executeInEDT() {
                ArrayList values = Lists.newArrayList();
                int size = list.getModel().getSize();
                for (int i = 0; i < size; ++i) {
                    String value = cellReader.valueAt(list, i);
                    if (!matcher.isMatching(value)) continue;
                    values.add(value);
                }
                return values;
            }
        });
        List list2 = (List)Preconditions.checkNotNull(result);
        if (list2 == null) {
            JListMatchingItemQuery.$$$reportNull$$$0(13);
        }
        return list2;
    }

    private JListMatchingItemQuery() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 9: 
            case 13: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 9: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellReader";
                break;
            }
            case 2: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JListMatchingItemQuery";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JListMatchingItemQuery";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "centerOfMatchingItemCell";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "matchingItemIndices";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "matchingItemValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "centerOfMatchingItemCell";
                break;
            }
            case 2: 
            case 9: 
            case 13: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "matchingItemIndex";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "matchingItemIndices";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "matchingItemValues";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 9: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

