/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.annotation.Nonnull;
import javax.swing.JList;
import org.fest.swing.annotation.RunsInCurrentThread;

final class JListItemPreconditions {
    @RunsInCurrentThread
    static void checkIndexInBounds(@Nonnull JList list, int index) {
        if (list == null) {
            JListItemPreconditions.$$$reportNull$$$0(0);
        }
        JListItemPreconditions.checkIndexInBounds(index, list.getModel().getSize());
    }

    @RunsInCurrentThread
    static void checkIndicesInBounds(@Nonnull JList list, int ... indices) {
        if (list == null) {
            JListItemPreconditions.$$$reportNull$$$0(1);
        }
        if (indices == null) {
            JListItemPreconditions.$$$reportNull$$$0(2);
        }
        int itemCount = list.getModel().getSize();
        for (int index : indices) {
            JListItemPreconditions.checkIndexInBounds(index, itemCount);
        }
    }

    private static void checkIndexInBounds(int index, int itemCount) {
        if (index >= 0 && index < itemCount) {
            return;
        }
        String format = "Item index (%d) should be between [0] and [%d] (inclusive)";
        String msg = String.format(format, index, itemCount - 1);
        throw new IndexOutOfBoundsException(msg);
    }

    private JListItemPreconditions() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indices";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/driver/JListItemPreconditions";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIndexInBounds";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIndicesInBounds";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

