/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyVetoException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JInternalFrameAction;
import org.fest.swing.driver.JInternalFrameCloseTask;
import org.fest.swing.driver.JInternalFrameIconQuery;
import org.fest.swing.driver.JInternalFrameSetIconTask;
import org.fest.swing.driver.JInternalFrameSetMaximumTask;
import org.fest.swing.driver.WindowLikeContainers;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.exception.UnexpectedException;
import org.fest.swing.format.Formatting;
import org.fest.swing.util.Pair;
import org.fest.swing.util.Triple;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;
import org.fest.util.VisibleForTesting;

@InternalApi
public class JInternalFrameDriver
extends JComponentDriver {
    public JInternalFrameDriver(@Nonnull Robot robot) {
        if (robot == null) {
            JInternalFrameDriver.$$$reportNull$$$0(0);
        }
        super(robot);
    }

    @RunsInEDT
    public void moveToFront(final @Nonnull JInternalFrame internalFrame) {
        if (internalFrame == null) {
            JInternalFrameDriver.$$$reportNull$$$0(1);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                internalFrame.toFront();
            }
        });
    }

    @RunsInEDT
    public void moveToBack(final @Nonnull JInternalFrame internalFrame) {
        if (internalFrame == null) {
            JInternalFrameDriver.$$$reportNull$$$0(2);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                internalFrame.moveToBack();
            }
        });
    }

    @RunsInEDT
    public void maximize(@Nonnull JInternalFrame internalFrame) {
        if (internalFrame == null) {
            JInternalFrameDriver.$$$reportNull$$$0(3);
        }
        Pair<Container, Point> maximizeLocation = JInternalFrameDriver.maximizeLocationOf(internalFrame);
        this.maximizeOrNormalize(internalFrame, JInternalFrameAction.MAXIMIZE, maximizeLocation);
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Container, Point> maximizeLocationOf(final @Nonnull JInternalFrame internalFrame) {
        if (internalFrame == null) {
            JInternalFrameDriver.$$$reportNull$$$0(4);
        }
        Pair<Container, Point> result = GuiActionRunner.execute(new GuiQuery<Pair<Container, Point>>(){

            @Override
            @Nullable
            protected Pair<Container, Point> executeInEDT() {
                JInternalFrameDriver.checkCanMaximize(internalFrame);
                return JInternalFrameDriver.findMaximizeLocation(internalFrame);
            }
        });
        Pair pair = (Pair)Preconditions.checkNotNull(result);
        if (pair == null) {
            JInternalFrameDriver.$$$reportNull$$$0(5);
        }
        return pair;
    }

    @RunsInCurrentThread
    private static void checkCanMaximize(@Nonnull JInternalFrame internalFrame) {
        if (internalFrame == null) {
            JInternalFrameDriver.$$$reportNull$$$0(6);
        }
        JInternalFrameDriver.checkShowingOrIconified(internalFrame);
        if (!internalFrame.isMaximizable()) {
            String msg = String.format("The JInternalFrame <%s> is not maximizable", Formatting.format(internalFrame));
            throw new IllegalStateException(msg);
        }
    }

    @RunsInEDT
    public void normalize(@Nonnull JInternalFrame internalFrame) {
        if (internalFrame == null) {
            JInternalFrameDriver.$$$reportNull$$$0(7);
        }
        Pair<Container, Point> normalizeLocation = JInternalFrameDriver.validateAndFindNormalizeLocation(internalFrame);
        this.maximizeOrNormalize(internalFrame, JInternalFrameAction.NORMALIZE, normalizeLocation);
    }

    @RunsInEDT
    private static Pair<Container, Point> validateAndFindNormalizeLocation(final @Nonnull JInternalFrame internalFrame) {
        if (internalFrame == null) {
            JInternalFrameDriver.$$$reportNull$$$0(8);
        }
        return GuiActionRunner.execute(new GuiQuery<Pair<Container, Point>>(){

            @Override
            protected Pair<Container, Point> executeInEDT() {
                JInternalFrameDriver.checkShowingOrIconified(internalFrame);
                return JInternalFrameDriver.findMaximizeLocation(internalFrame);
            }
        });
    }

    @RunsInCurrentThread
    private static void checkShowingOrIconified(@Nonnull JInternalFrame internalFrame) {
        if (internalFrame == null) {
            JInternalFrameDriver.$$$reportNull$$$0(9);
        }
        if (!internalFrame.isIcon()) {
            ComponentPreconditions.checkShowing(internalFrame);
        }
    }

    @Nonnull
    @RunsInCurrentThread
    private static Pair<Container, Point> findMaximizeLocation(@Nonnull JInternalFrame internalFrame) {
        if (internalFrame == null) {
            JInternalFrameDriver.$$$reportNull$$$0(10);
        }
        JComponent clickTarget = internalFrame.isIcon() ? internalFrame.getDesktopIcon() : internalFrame;
        Point location = WindowLikeContainers.maximizeButtonLocation((Container)Preconditions.checkNotNull((Object)clickTarget));
        Pair<Container, Point> pair = Pair.of(clickTarget, location);
        if (pair == null) {
            JInternalFrameDriver.$$$reportNull$$$0(11);
        }
        return pair;
    }

    @RunsInEDT
    private void maximizeOrNormalize(@Nonnull JInternalFrame internalFrame, @Nonnull JInternalFrameAction action, @Nonnull Pair<Container, Point> toMoveMouseTo) {
        if (internalFrame == null) {
            JInternalFrameDriver.$$$reportNull$$$0(12);
        }
        if (action == null) {
            JInternalFrameDriver.$$$reportNull$$$0(13);
        }
        if (toMoveMouseTo == null) {
            JInternalFrameDriver.$$$reportNull$$$0(14);
        }
        this.moveMouseIgnoringAnyError((Component)toMoveMouseTo.first, (Point)toMoveMouseTo.second);
        this.setMaximumProperty(internalFrame, action);
    }

    @RunsInEDT
    private void setMaximumProperty(@Nonnull JInternalFrame internalFrame, @Nonnull JInternalFrameAction action) {
        if (internalFrame == null) {
            JInternalFrameDriver.$$$reportNull$$$0(15);
        }
        if (action == null) {
            JInternalFrameDriver.$$$reportNull$$$0(16);
        }
        try {
            JInternalFrameSetMaximumTask.setMaximum(internalFrame, action);
            this.robot.waitForIdle();
        }
        catch (UnexpectedException unexpected) {
            this.failIfVetoed(internalFrame, action, unexpected);
        }
    }

    @RunsInEDT
    public void iconify(@Nonnull JInternalFrame internalFrame) {
        if (internalFrame == null) {
            JInternalFrameDriver.$$$reportNull$$$0(17);
        }
        Pair<Boolean, Point> iconifyInfo = JInternalFrameDriver.findIconifyInfo(internalFrame);
        if (((Boolean)iconifyInfo.first).booleanValue()) {
            return;
        }
        this.moveMouseIgnoringAnyError(internalFrame, (Point)iconifyInfo.second);
        this.setIconProperty(internalFrame, JInternalFrameAction.ICONIFY);
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Boolean, Point> findIconifyInfo(final @Nonnull JInternalFrame internalFrame) {
        if (internalFrame == null) {
            JInternalFrameDriver.$$$reportNull$$$0(18);
        }
        Pair<Boolean, Point> result = GuiActionRunner.execute(new GuiQuery<Pair<Boolean, Point>>(){

            @Override
            @Nullable
            protected Pair<Boolean, Point> executeInEDT() throws Throwable {
                JInternalFrameDriver.checkShowingOrIconified(internalFrame);
                if (!internalFrame.isIconifiable()) {
                    String msg = String.format("The JInternalFrame <%s> is not iconifiable.", Formatting.format(internalFrame));
                    throw new IllegalStateException(msg);
                }
                return JInternalFrameDriver.iconifyInfo(internalFrame);
            }
        });
        Pair pair = (Pair)Preconditions.checkNotNull(result);
        if (pair == null) {
            JInternalFrameDriver.$$$reportNull$$$0(19);
        }
        return pair;
    }

    @Nonnull
    @RunsInCurrentThread
    private static Pair<Boolean, Point> iconifyInfo(@Nonnull JInternalFrame internalFrame) {
        boolean iconified;
        if (internalFrame == null) {
            JInternalFrameDriver.$$$reportNull$$$0(20);
        }
        if (iconified = JInternalFrameIconQuery.isIconified(internalFrame)) {
            Pair<Boolean, Object> pair = Pair.of(true, null);
            if (pair == null) {
                JInternalFrameDriver.$$$reportNull$$$0(21);
            }
            return pair;
        }
        Pair<Boolean, Point> pair = Pair.of(iconified, JInternalFrameDriver.findIconifyLocation(internalFrame));
        if (pair == null) {
            JInternalFrameDriver.$$$reportNull$$$0(22);
        }
        return pair;
    }

    @RunsInEDT
    public void deiconify(@Nonnull JInternalFrame internalFrame) {
        if (internalFrame == null) {
            JInternalFrameDriver.$$$reportNull$$$0(23);
        }
        Triple<Boolean, Container, Point> deiconifyInfo = JInternalFrameDriver.validateAndfindDeiconifyInfo(internalFrame);
        if (((Boolean)deiconifyInfo.first).booleanValue()) {
            return;
        }
        this.moveMouseIgnoringAnyError((Component)deiconifyInfo.second, (Point)deiconifyInfo.third);
        this.setIconProperty(internalFrame, JInternalFrameAction.DEICONIFY);
    }

    @Nonnull
    @RunsInEDT
    private static Triple<Boolean, Container, Point> validateAndfindDeiconifyInfo(final @Nonnull JInternalFrame internalFrame) {
        if (internalFrame == null) {
            JInternalFrameDriver.$$$reportNull$$$0(24);
        }
        Triple<Boolean, Container, Point> result = GuiActionRunner.execute(new GuiQuery<Triple<Boolean, Container, Point>>(){

            @Override
            @Nullable
            protected Triple<Boolean, Container, Point> executeInEDT() throws Throwable {
                JInternalFrameDriver.checkShowingOrIconified(internalFrame);
                return JInternalFrameDriver.deiconifyInfo(internalFrame);
            }
        });
        Triple triple = (Triple)Preconditions.checkNotNull(result);
        if (triple == null) {
            JInternalFrameDriver.$$$reportNull$$$0(25);
        }
        return triple;
    }

    @Nonnull
    @RunsInCurrentThread
    private static Triple<Boolean, Container, Point> deiconifyInfo(@Nonnull JInternalFrame internalFrame) {
        boolean deiconified;
        if (internalFrame == null) {
            JInternalFrameDriver.$$$reportNull$$$0(26);
        }
        boolean bl = deiconified = !JInternalFrameIconQuery.isIconified(internalFrame);
        if (deiconified) {
            Triple<Boolean, Object, Object> triple = Triple.of(true, null, null);
            if (triple == null) {
                JInternalFrameDriver.$$$reportNull$$$0(27);
            }
            return triple;
        }
        Container desktopIcon = (Container)Preconditions.checkNotNull((Object)internalFrame.getDesktopIcon());
        Triple<Boolean, Container, Point> triple = Triple.of(deiconified, desktopIcon, WindowLikeContainers.iconifyButtonLocation(desktopIcon));
        if (triple == null) {
            JInternalFrameDriver.$$$reportNull$$$0(28);
        }
        return triple;
    }

    @Nonnull
    @RunsInCurrentThread
    private static Point findIconifyLocation(JInternalFrame internalFrame) {
        JInternalFrame.JDesktopIcon desktopIcon = (JInternalFrame.JDesktopIcon)Preconditions.checkNotNull((Object)internalFrame.getDesktopIcon());
        Point point = WindowLikeContainers.iconifyButtonLocation(desktopIcon);
        if (point == null) {
            JInternalFrameDriver.$$$reportNull$$$0(29);
        }
        return point;
    }

    @RunsInEDT
    private void setIconProperty(@Nonnull JInternalFrame internalFrame, @Nonnull JInternalFrameAction action) {
        if (internalFrame == null) {
            JInternalFrameDriver.$$$reportNull$$$0(30);
        }
        if (action == null) {
            JInternalFrameDriver.$$$reportNull$$$0(31);
        }
        try {
            JInternalFrameSetIconTask.setIcon(internalFrame, action);
            this.robot.waitForIdle();
        }
        catch (UnexpectedException unexpected) {
            this.failIfVetoed(internalFrame, action, unexpected);
        }
    }

    @VisibleForTesting
    void failIfVetoed(@Nonnull JInternalFrame internalFrame, @Nonnull JInternalFrameAction action, @Nonnull UnexpectedException unexpected) {
        PropertyVetoException vetoError;
        if (internalFrame == null) {
            JInternalFrameDriver.$$$reportNull$$$0(32);
        }
        if (action == null) {
            JInternalFrameDriver.$$$reportNull$$$0(33);
        }
        if (unexpected == null) {
            JInternalFrameDriver.$$$reportNull$$$0(34);
        }
        if ((vetoError = this.vetoFrom(unexpected)) == null) {
            return;
        }
        String msg = String.format("%s of %s was vetoed: <%s>", action.name, Formatting.format(internalFrame), vetoError.getMessage());
        throw ActionFailedException.actionFailure(msg);
    }

    @Nullable
    private PropertyVetoException vetoFrom(@Nonnull UnexpectedException unexpected) {
        Throwable cause;
        if (unexpected == null) {
            JInternalFrameDriver.$$$reportNull$$$0(35);
        }
        if (!((cause = unexpected.getCause()) instanceof PropertyVetoException)) {
            return null;
        }
        return (PropertyVetoException)cause;
    }

    @RunsInEDT
    public void resizeWidth(@Nonnull JInternalFrame internalFrame, int width) {
        if (internalFrame == null) {
            JInternalFrameDriver.$$$reportNull$$$0(36);
        }
        this.doResizeWidth(internalFrame, width);
    }

    @RunsInEDT
    public void resizeHeight(@Nonnull JInternalFrame w, int height) {
        if (w == null) {
            JInternalFrameDriver.$$$reportNull$$$0(37);
        }
        this.doResizeHeight(w, height);
    }

    @RunsInEDT
    public void resizeTo(@Nonnull JInternalFrame internalFrame, @Nonnull Dimension size) {
        if (internalFrame == null) {
            JInternalFrameDriver.$$$reportNull$$$0(38);
        }
        if (size == null) {
            JInternalFrameDriver.$$$reportNull$$$0(39);
        }
        this.resize(internalFrame, size.width, size.height);
    }

    @RunsInEDT
    public void move(@Nonnull JInternalFrame internalFrame, @Nonnull Point where) {
        if (internalFrame == null) {
            JInternalFrameDriver.$$$reportNull$$$0(40);
        }
        if (where == null) {
            JInternalFrameDriver.$$$reportNull$$$0(41);
        }
        this.move(internalFrame, where.x, where.y);
    }

    @RunsInEDT
    public void close(@Nonnull JInternalFrame internalFrame) {
        Point closeButtonLocation;
        if (internalFrame == null) {
            JInternalFrameDriver.$$$reportNull$$$0(42);
        }
        if ((closeButtonLocation = JInternalFrameDriver.findCloseButtonLocation(internalFrame)) == null) {
            return;
        }
        this.moveMouseIgnoringAnyError(internalFrame, closeButtonLocation);
        JInternalFrameCloseTask.close(internalFrame);
        this.robot.waitForIdle();
    }

    @Nullable
    @RunsInEDT
    private static Point findCloseButtonLocation(final @Nonnull JInternalFrame internalFrame) {
        if (internalFrame == null) {
            JInternalFrameDriver.$$$reportNull$$$0(43);
        }
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            @Nullable
            protected Point executeInEDT() {
                ComponentPreconditions.checkShowing(internalFrame);
                if (!internalFrame.isClosable()) {
                    String msg = String.format("The JInternalFrame <%s> is not closable", Formatting.format(internalFrame));
                    throw new IllegalStateException(msg);
                }
                if (internalFrame.isClosed()) {
                    return null;
                }
                return WindowLikeContainers.closeButtonLocation(internalFrame);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 11: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 27: 
            case 28: 
            case 29: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 11: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 30: 
            case 32: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internalFrame";
                break;
            }
            case 5: 
            case 11: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JInternalFrameDriver";
                break;
            }
            case 13: 
            case 16: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toMoveMouseTo";
                break;
            }
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unexpected";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "w";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JInternalFrameDriver";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "maximizeLocationOf";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findMaximizeLocation";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findIconifyInfo";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "iconifyInfo";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "validateAndfindDeiconifyInfo";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "deiconifyInfo";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "findIconifyLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "moveToFront";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "moveToBack";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "maximize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "maximizeLocationOf";
                break;
            }
            case 5: 
            case 11: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkCanMaximize";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validateAndFindNormalizeLocation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkShowingOrIconified";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findMaximizeLocation";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "maximizeOrNormalize";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setMaximumProperty";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "iconify";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findIconifyInfo";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "iconifyInfo";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "deiconify";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "validateAndfindDeiconifyInfo";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "deiconifyInfo";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setIconProperty";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "failIfVetoed";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "vetoFrom";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "resizeWidth";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "resizeHeight";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "resizeTo";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "move";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "close";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findCloseButtonLocation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 11: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

