/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.annotation.Nonnull;
import javax.swing.JComboBox;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.util.Strings;

final class JComboBoxItemIndexPreconditions {
    @RunsInCurrentThread
    static void checkItemIndexInBounds(@Nonnull JComboBox comboBox, int index) {
        if (comboBox == null) {
            JComboBoxItemIndexPreconditions.$$$reportNull$$$0(0);
        }
        if (index < 0) {
            String msg = String.format("%s should not be less than zero", JComboBoxItemIndexPreconditions.itemIndex(index));
            throw new IndexOutOfBoundsException(msg);
        }
        int itemCount = comboBox.getItemCount();
        if (itemCount == 0) {
            throw new IndexOutOfBoundsException("JComboBox is empty");
        }
        if (index >= 0 && index < itemCount) {
            return;
        }
        String msg = String.format("%s should be between [0] and [%d] (inclusive)", JComboBoxItemIndexPreconditions.itemIndex(index), itemCount - 1);
        throw new IndexOutOfBoundsException(msg);
    }

    private static String itemIndex(int index) {
        return Strings.concat((Object[])new Object[]{"Item index (", String.valueOf(index), ")"});
    }

    private JComboBoxItemIndexPreconditions() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", "comboBox", "org/fest/swing/driver/JComboBoxItemIndexPreconditions", "checkItemIndexInBounds"));
    }
}

