/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.annotation.ThreadSafeAction;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.WindowDriver;
import org.fest.swing.driver.WindowLikeContainers;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.util.ToolkitProvider;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

@InternalApi
public class FrameDriver
extends WindowDriver {
    public FrameDriver(@Nonnull Robot robot) {
        if (robot == null) {
            FrameDriver.$$$reportNull$$$0(0);
        }
        super(robot);
    }

    @RunsInEDT
    public void iconify(@Nonnull Frame frame) {
        if (frame == null) {
            FrameDriver.$$$reportNull$$$0(1);
        }
        this.moveMouseIgnoringAnyError(frame, FrameDriver.iconifyInfo(frame));
        this.robot.waitForIdle();
        this.updateFrameExtendedState(frame, 1);
    }

    @RunsInEDT
    private static Point iconifyInfo(final @Nonnull Frame frame) {
        if (frame == null) {
            FrameDriver.$$$reportNull$$$0(2);
        }
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(frame);
                return WindowLikeContainers.iconifyButtonLocation(frame);
            }
        });
    }

    @RunsInEDT
    public void deiconify(@Nonnull Frame frame) {
        if (frame == null) {
            FrameDriver.$$$reportNull$$$0(3);
        }
        FrameDriver.checkInEdtEnabledAndShowing(frame);
        this.updateFrameExtendedState(frame, 0);
    }

    @RunsInEDT
    public void normalize(@Nonnull Frame frame) {
        if (frame == null) {
            FrameDriver.$$$reportNull$$$0(4);
        }
        FrameDriver.checkInEdtEnabledAndShowing(frame);
        this.updateFrameExtendedState(frame, 0);
    }

    @RunsInEDT
    public void maximize(@Nonnull Frame frame) {
        if (frame == null) {
            FrameDriver.$$$reportNull$$$0(5);
        }
        this.moveMouseIgnoringAnyError(frame, FrameDriver.maximizeInfo(frame));
        if (!FrameDriver.supportsMaximize(ToolkitProvider.instance().defaultToolkit())) {
            throw ActionFailedException.actionFailure("Platform does not support maximizing frames");
        }
        this.updateFrameExtendedState(frame, 6);
    }

    @Nonnull
    @RunsInEDT
    private static Point maximizeInfo(final @Nonnull Frame frame) {
        if (frame == null) {
            FrameDriver.$$$reportNull$$$0(6);
        }
        Point result = GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            @Nullable
            protected Point executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(frame);
                return WindowLikeContainers.maximizeButtonLocation(frame);
            }
        });
        Point point = (Point)Preconditions.checkNotNull((Object)result);
        if (point == null) {
            FrameDriver.$$$reportNull$$$0(7);
        }
        return point;
    }

    @ThreadSafeAction
    private void updateFrameExtendedState(@Nonnull Frame frame, int state) {
        if (frame == null) {
            FrameDriver.$$$reportNull$$$0(8);
        }
        frame.setExtendedState(state);
    }

    private static boolean supportsMaximize(@Nonnull Toolkit toolkit) {
        if (toolkit == null) {
            FrameDriver.$$$reportNull$$$0(9);
        }
        return toolkit.isFrameStateSupported(6);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/FrameDriver";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolkit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/FrameDriver";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "maximizeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "iconify";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "iconifyInfo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deiconify";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "maximize";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "maximizeInfo";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateFrameExtendedState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "supportsMaximize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

