/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.exception.WaitTimedOutError;
import org.fest.swing.query.ComponentVisibleQuery;
import org.fest.swing.timing.Pause;
import org.fest.swing.util.TimeoutWatch;

public final class ComponentShownWaiter
extends ComponentAdapter {
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final int DEFAULT_SLEEP_TIME = 10;
    private Component toWaitFor;
    private volatile boolean shown;

    public static void waitTillShown(@Nonnull Component toWaitFor) {
        if (toWaitFor == null) {
            ComponentShownWaiter.$$$reportNull$$$0(0);
        }
        new ComponentShownWaiter(toWaitFor).startWaiting(5000L);
    }

    public static void waitTillShown(@Nonnull Component toWaitFor, long timeout) {
        if (toWaitFor == null) {
            ComponentShownWaiter.$$$reportNull$$$0(1);
        }
        new ComponentShownWaiter(toWaitFor).startWaiting(timeout);
    }

    private ComponentShownWaiter(@Nonnull Component toWaitFor) {
        if (toWaitFor == null) {
            ComponentShownWaiter.$$$reportNull$$$0(2);
        }
        this.toWaitFor = toWaitFor;
        toWaitFor.addComponentListener(this);
    }

    private void startWaiting(long timeout) {
        if (this.alreadyVisible()) {
            return;
        }
        TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(timeout);
        while (!this.shown) {
            Pause.pause(10L);
            if (!watch.isTimeOut()) continue;
            this.done();
            throw new WaitTimedOutError("Timed out waiting for component to be visible");
        }
    }

    private boolean alreadyVisible() {
        if (!ComponentVisibleQuery.isVisible(this.toWaitFor)) {
            return false;
        }
        this.done();
        return true;
    }

    @Override
    @RunsInEDT
    public void componentShown(@Nullable ComponentEvent e) {
        this.shown = true;
        this.done();
    }

    private void done() {
        this.toWaitFor.removeComponentListener(this);
        this.toWaitFor = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "toWaitFor";
        objectArray2[1] = "org/fest/swing/driver/ComponentShownWaiter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "waitTillShown";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

