/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import javax.annotation.Nonnull;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.format.Formatting;
import org.fest.util.Strings;

public final class ComponentPreconditions {
    @RunsInCurrentThread
    public static void checkEnabledAndShowing(@Nonnull Component c) {
        if (c == null) {
            ComponentPreconditions.$$$reportNull$$$0(0);
        }
        ComponentPreconditions.checkEnabled(c);
        ComponentPreconditions.checkShowing(c);
    }

    @RunsInCurrentThread
    public static void checkEnabled(@Nonnull Component c) {
        if (c == null) {
            ComponentPreconditions.$$$reportNull$$$0(1);
        }
        if (!c.isEnabled()) {
            throw new IllegalStateException(Strings.concat((Object[])new Object[]{"Expecting component ", Formatting.format(c), " to be enabled"}));
        }
    }

    @RunsInCurrentThread
    public static void checkShowing(@Nonnull Component c) {
        if (c == null) {
            ComponentPreconditions.$$$reportNull$$$0(2);
        }
        if (!c.isShowing()) {
            String msg = String.format("Expecting component %s to be showing on the screen", Formatting.format(c));
            throw new IllegalStateException(msg);
        }
    }

    private ComponentPreconditions() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "c";
        objectArray2[1] = "org/fest/swing/driver/ComponentPreconditions";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkEnabledAndShowing";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkShowing";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

