/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import javax.annotation.Nonnull;
import org.fest.assertions.Description;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.edt.GuiLazyLoadingDescription;
import org.fest.swing.format.Formatting;
import org.fest.swing.query.ComponentEnabledQuery;
import org.fest.swing.timing.Condition;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

class ComponentEnabledCondition
extends Condition {
    private Component c;

    @Nonnull
    static ComponentEnabledCondition untilIsEnabled(@Nonnull Component c) {
        if (c == null) {
            ComponentEnabledCondition.$$$reportNull$$$0(0);
        }
        ComponentEnabledCondition componentEnabledCondition = new ComponentEnabledCondition(c);
        if (componentEnabledCondition == null) {
            ComponentEnabledCondition.$$$reportNull$$$0(1);
        }
        return componentEnabledCondition;
    }

    private ComponentEnabledCondition(@Nonnull Component c) {
        if (c == null) {
            ComponentEnabledCondition.$$$reportNull$$$0(2);
        }
        super(ComponentEnabledCondition.description(c));
        this.c = c;
    }

    @Nonnull
    private static Description description(final @Nonnull Component c) {
        if (c == null) {
            ComponentEnabledCondition.$$$reportNull$$$0(3);
        }
        GuiLazyLoadingDescription guiLazyLoadingDescription = new GuiLazyLoadingDescription(){

            @Override
            @Nonnull
            protected String loadDescription() {
                String string = Strings.concat((Object[])new Object[]{Formatting.format(c), " to be enabled"});
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", "org/fest/swing/driver/ComponentEnabledCondition$1", "loadDescription"));
            }
        };
        if (guiLazyLoadingDescription == null) {
            ComponentEnabledCondition.$$$reportNull$$$0(4);
        }
        return guiLazyLoadingDescription;
    }

    @Override
    @RunsInEDT
    public boolean test() {
        return ComponentEnabledQuery.isEnabled((Component)Preconditions.checkNotNull((Object)this.c));
    }

    @Override
    protected void done() {
        this.c = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/ComponentEnabledCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/ComponentEnabledCondition";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "untilIsEnabled";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "description";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "untilIsEnabled";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "description";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

