/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.Action;
import javax.swing.ActionMap;
import org.fest.swing.exception.ActionFailedException;
import org.fest.util.Lists;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

final class Actions {
    @Nonnull
    static Object findActionKey(@Nonnull String name, @Nonnull ActionMap actionMap) {
        Action action;
        if (name == null) {
            Actions.$$$reportNull$$$0(0);
        }
        if (actionMap == null) {
            Actions.$$$reportNull$$$0(1);
        }
        if ((action = actionMap.get(name)) != null) {
            String string = name;
            if (string == null) {
                Actions.$$$reportNull$$$0(2);
            }
            return string;
        }
        Object[] allKeys = actionMap.allKeys();
        if (allKeys != null) {
            for (Object key : allKeys) {
                action = actionMap.get(key);
                if (!name.equals(action.getValue("Name"))) continue;
                Object object = Preconditions.checkNotNull((Object)key);
                if (object == null) {
                    Actions.$$$reportNull$$$0(3);
                }
                return object;
            }
        }
        String message = String.format("The action '%s' is not available", name);
        if (allKeys != null && allKeys.length > 0) {
            message = Strings.concat((Object[])new Object[]{message, ", available actions:", Actions.formatAllActionKeys(allKeys)});
        }
        throw ActionFailedException.actionFailure(message);
    }

    @Nonnull
    private static List<String> formatAllActionKeys(@Nonnull Object[] keys) {
        if (keys == null) {
            Actions.$$$reportNull$$$0(4);
        }
        ArrayList formattedKeys = Lists.newArrayList();
        for (Object key : keys) {
            String keyAsString = Actions.keyAsString(key);
            if (keyAsString == null) continue;
            formattedKeys.add(keyAsString);
        }
        Collections.sort(formattedKeys);
        ArrayList arrayList = formattedKeys;
        if (arrayList == null) {
            Actions.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Nullable
    private static String keyAsString(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        if (key instanceof String) {
            return (String)Strings.quote((Object)key);
        }
        return String.format("%s(%s)", key.toString(), key.getClass().getName());
    }

    private Actions() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionMap";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/Actions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/Actions";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findActionKey";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "formatAllActionKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findActionKey";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "formatAllActionKeys";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

