/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.data;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JTable;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JTableCellReader;
import org.fest.swing.data.TableCell;
import org.fest.swing.data.TableCellFinder;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.query.JTableColumnByIdentifierQuery;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

public class TableCellByColumnId
implements TableCellFinder {
    public final int row;
    public final Object columnId;

    public static TableCellBuilder row(int row) {
        return new TableCellBuilder(row);
    }

    protected TableCellByColumnId(int row, @Nonnull Object columnId) {
        if (columnId == null) {
            TableCellByColumnId.$$$reportNull$$$0(0);
        }
        this.row = row;
        this.columnId = columnId;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public TableCell findCell(@Nonnull JTable table, @Nonnull JTableCellReader cellReader) {
        if (table == null) {
            TableCellByColumnId.$$$reportNull$$$0(1);
        }
        if (cellReader == null) {
            TableCellByColumnId.$$$reportNull$$$0(2);
        }
        TableCell tableCell = TableCellByColumnId.findCell(table, this.row, this.columnId);
        if (tableCell == null) {
            TableCellByColumnId.$$$reportNull$$$0(3);
        }
        return tableCell;
    }

    @Nonnull
    @RunsInEDT
    private static TableCell findCell(final @Nonnull JTable table, final int row, final @Nonnull Object columnId) {
        if (table == null) {
            TableCellByColumnId.$$$reportNull$$$0(4);
        }
        if (columnId == null) {
            TableCellByColumnId.$$$reportNull$$$0(5);
        }
        TableCell result = GuiActionRunner.execute(new GuiQuery<TableCell>(){

            @Override
            @Nullable
            protected TableCell executeInEDT() {
                int column = JTableColumnByIdentifierQuery.columnIndexByIdentifier(table, columnId);
                if (column == -1) {
                    TableCellByColumnId.failColumnIndexNotFound(columnId);
                }
                table.convertColumnIndexToView(table.getColumn(columnId).getModelIndex());
                return new TableCell(row, column);
            }
        });
        TableCell tableCell = (TableCell)Preconditions.checkNotNull((Object)result);
        if (tableCell == null) {
            TableCellByColumnId.$$$reportNull$$$0(6);
        }
        return tableCell;
    }

    private static ActionFailedException failColumnIndexNotFound(Object columnId) {
        throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Unable to find a column with id ", Strings.quote((Object)columnId)}));
    }

    public String toString() {
        return Strings.concat((Object[])new Object[]{this.getClass().getName(), "[row=", String.valueOf(this.row), ", columnId=", Strings.quote((Object)this.columnId), "]"});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnId";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellReader";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/data/TableCellByColumnId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/data/TableCellByColumnId";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findCell";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findCell";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TableCellBuilder {
        private final int row;

        TableCellBuilder(int row) {
            this.row = row;
        }

        public TableCellByColumnId columnId(@Nonnull Object columnId) {
            if (columnId == null) {
                TableCellBuilder.$$$reportNull$$$0(0);
            }
            return new TableCellByColumnId(this.row, columnId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", "columnId", "org/fest/swing/data/TableCellByColumnId$TableCellBuilder", "columnId"));
        }
    }
}

