/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core.matcher;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JButton;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.core.matcher.NamedComponentMatcherTemplate;

public final class JButtonMatcher
extends NamedComponentMatcherTemplate<JButton> {
    private Object text;

    @Nonnull
    public static JButtonMatcher withName(@Nullable String name) {
        JButtonMatcher jButtonMatcher = new JButtonMatcher(name, JButtonMatcher.anyValue());
        if (jButtonMatcher == null) {
            JButtonMatcher.$$$reportNull$$$0(0);
        }
        return jButtonMatcher;
    }

    @Nonnull
    public static JButtonMatcher withText(@Nullable String text) {
        JButtonMatcher jButtonMatcher = new JButtonMatcher(JButtonMatcher.anyValue(), (Object)text);
        if (jButtonMatcher == null) {
            JButtonMatcher.$$$reportNull$$$0(1);
        }
        return jButtonMatcher;
    }

    @Nonnull
    public static JButtonMatcher withText(@Nonnull Pattern pattern) {
        if (pattern == null) {
            JButtonMatcher.$$$reportNull$$$0(2);
        }
        JButtonMatcher jButtonMatcher = new JButtonMatcher(JButtonMatcher.anyValue(), (Object)pattern);
        if (jButtonMatcher == null) {
            JButtonMatcher.$$$reportNull$$$0(3);
        }
        return jButtonMatcher;
    }

    public static JButtonMatcher any() {
        return new JButtonMatcher(JButtonMatcher.anyValue(), JButtonMatcher.anyValue());
    }

    private JButtonMatcher(@Nullable Object name, @Nullable Object text) {
        super(JButton.class, name);
        this.text = text;
    }

    @Nonnull
    public JButtonMatcher andText(@Nullable String newText) {
        this.text = newText;
        JButtonMatcher jButtonMatcher = this;
        if (jButtonMatcher == null) {
            JButtonMatcher.$$$reportNull$$$0(4);
        }
        return jButtonMatcher;
    }

    public JButtonMatcher andText(@Nonnull Pattern textPattern) {
        if (textPattern == null) {
            JButtonMatcher.$$$reportNull$$$0(5);
        }
        this.text = textPattern;
        return this;
    }

    @Nonnull
    public JButtonMatcher andShowing() {
        this.requireShowing(true);
        JButtonMatcher jButtonMatcher = this;
        if (jButtonMatcher == null) {
            JButtonMatcher.$$$reportNull$$$0(6);
        }
        return jButtonMatcher;
    }

    @Override
    @RunsInCurrentThread
    protected boolean isMatching(@Nonnull JButton button) {
        if (button == null) {
            JButtonMatcher.$$$reportNull$$$0(7);
        }
        return this.isNameMatching(button.getName()) && this.arePropertyValuesMatching(this.text, button.getText());
    }

    public String toString() {
        String format = "%s[name=%s, text=%s, requireShowing=%b]";
        return String.format(format, this.getClass().getName(), this.quotedName(), this.quoted(this.text), this.requireShowing());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/core/matcher/JButtonMatcher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textPattern";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "withName";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "withText";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/core/matcher/JButtonMatcher";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "andText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "andShowing";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "andText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isMatching";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

