/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core.matcher;

import java.awt.Dialog;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.core.matcher.NamedComponentMatcherTemplate;

public final class DialogMatcher
extends NamedComponentMatcherTemplate<Dialog> {
    private Object title;

    public static DialogMatcher withName(@Nullable String name) {
        return new DialogMatcher(name, DialogMatcher.anyValue());
    }

    @Nonnull
    public static DialogMatcher withTitle(@Nullable String title) {
        DialogMatcher dialogMatcher = new DialogMatcher(DialogMatcher.anyValue(), (Object)title);
        if (dialogMatcher == null) {
            DialogMatcher.$$$reportNull$$$0(0);
        }
        return dialogMatcher;
    }

    @Nonnull
    public static DialogMatcher withTitle(@Nonnull Pattern pattern) {
        if (pattern == null) {
            DialogMatcher.$$$reportNull$$$0(1);
        }
        DialogMatcher dialogMatcher = new DialogMatcher(DialogMatcher.anyValue(), (Object)pattern);
        if (dialogMatcher == null) {
            DialogMatcher.$$$reportNull$$$0(2);
        }
        return dialogMatcher;
    }

    @Nonnull
    public static DialogMatcher any() {
        DialogMatcher dialogMatcher = new DialogMatcher(DialogMatcher.anyValue(), DialogMatcher.anyValue());
        if (dialogMatcher == null) {
            DialogMatcher.$$$reportNull$$$0(3);
        }
        return dialogMatcher;
    }

    private DialogMatcher(@Nullable Object name, @Nullable Object title) {
        super(Dialog.class, name);
        this.title = title;
    }

    @Nonnull
    public DialogMatcher andTitle(@Nullable String newTitle) {
        this.title = newTitle;
        DialogMatcher dialogMatcher = this;
        if (dialogMatcher == null) {
            DialogMatcher.$$$reportNull$$$0(4);
        }
        return dialogMatcher;
    }

    public DialogMatcher andTitle(@Nonnull Pattern titlePattern) {
        if (titlePattern == null) {
            DialogMatcher.$$$reportNull$$$0(5);
        }
        this.title = titlePattern;
        return this;
    }

    @Nonnull
    public DialogMatcher andShowing() {
        this.requireShowing(true);
        DialogMatcher dialogMatcher = this;
        if (dialogMatcher == null) {
            DialogMatcher.$$$reportNull$$$0(6);
        }
        return dialogMatcher;
    }

    @Override
    @RunsInCurrentThread
    protected boolean isMatching(@Nonnull Dialog dialog) {
        if (dialog == null) {
            DialogMatcher.$$$reportNull$$$0(7);
        }
        return this.isNameMatching(dialog.getName()) && this.arePropertyValuesMatching(this.title, dialog.getTitle());
    }

    public String toString() {
        String format = "%s[name=%s, title=%s, requireShowing=%b]";
        return String.format(format, this.getClass().getName(), this.quotedName(), this.quoted(this.title), this.requireShowing());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/core/matcher/DialogMatcher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titlePattern";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "withTitle";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/core/matcher/DialogMatcher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "any";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "andTitle";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "andShowing";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "withTitle";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "andTitle";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isMatching";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

