/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.core.AbstractComponentMatcher;
import org.fest.util.Preconditions;

public final class TypeMatcher
extends AbstractComponentMatcher {
    private final Class<? extends Component> type;

    public TypeMatcher(@Nonnull Class<? extends Component> type) {
        if (type == null) {
            TypeMatcher.$$$reportNull$$$0(0);
        }
        this(type, false);
    }

    public TypeMatcher(@Nonnull Class<? extends Component> type, boolean requireShowing) {
        if (type == null) {
            TypeMatcher.$$$reportNull$$$0(1);
        }
        super(requireShowing);
        this.type = (Class)Preconditions.checkNotNull(type);
    }

    @Override
    @RunsInCurrentThread
    public boolean matches(@Nullable Component c) {
        if (c == null) {
            return false;
        }
        return this.type.isAssignableFrom(c.getClass()) && this.requireShowingMatches(c);
    }

    public String toString() {
        return String.format("%s[type=%s, requireShowing=%b]", this.getClass().getName(), this.type.getName(), this.requireShowing());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", "type", "org/fest/swing/core/TypeMatcher", "<init>"));
    }
}

