/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import javax.annotation.Nonnull;
import org.fest.swing.core.FrameDisposer;
import org.fest.swing.core.MainThreadIdentifier;
import org.fest.swing.core.SimpleFallbackExceptionHandler;
import org.fest.swing.core.ThreadsSource;
import org.fest.swing.util.AWTExceptionHandlerInstaller;

class TestTerminator {
    private final ThreadsSource threadsSource;
    private final FrameDisposer frameDisposer;
    private final MainThreadIdentifier mainThreadIdentifier;

    TestTerminator() {
        this(new ThreadsSource(), new FrameDisposer(), new MainThreadIdentifier());
    }

    TestTerminator(@Nonnull ThreadsSource threadsSource, @Nonnull FrameDisposer frameDisposer, @Nonnull MainThreadIdentifier mainThreadIdentifier) {
        if (threadsSource == null) {
            TestTerminator.$$$reportNull$$$0(0);
        }
        if (frameDisposer == null) {
            TestTerminator.$$$reportNull$$$0(1);
        }
        if (mainThreadIdentifier == null) {
            TestTerminator.$$$reportNull$$$0(2);
        }
        this.threadsSource = threadsSource;
        this.frameDisposer = frameDisposer;
        this.mainThreadIdentifier = mainThreadIdentifier;
    }

    void terminateTests() {
        this.pokeMainThread();
        this.frameDisposer.disposeFrames();
        throw new RuntimeException("User aborted FEST-Swing tests");
    }

    private void pokeMainThread() {
        Thread mainThread = this.mainThreadIdentifier.mainThreadIn(this.threadsSource.allThreads());
        if (mainThread != null) {
            mainThread.interrupt();
        }
    }

    static {
        AWTExceptionHandlerInstaller.installAWTExceptionHandler(SimpleFallbackExceptionHandler.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "threadsSource";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "frameDisposer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "mainThreadIdentifier";
                break;
            }
        }
        objectArray[1] = "org/fest/swing/core/TestTerminator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

