/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.fest.swing.core.Robot;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;
import org.fest.util.Preconditions;

public final class Scrolling {
    public static void scrollToVisible(@Nonnull Robot robot, @Nonnull JComponent c) {
        if (robot == null) {
            Scrolling.$$$reportNull$$$0(0);
        }
        if (c == null) {
            Scrolling.$$$reportNull$$$0(1);
        }
        JComponent root = Scrolling.findClosestValidatingRootAncestor(c);
        while (root != null) {
            Scrolling.scrollToVisible(robot, root, c);
            root = Scrolling.findClosestValidatingRootAncestor(root);
        }
    }

    @Nullable
    private static JComponent findClosestValidatingRootAncestor(@Nonnull JComponent c) {
        if (c == null) {
            Scrolling.$$$reportNull$$$0(2);
        }
        Container root = c;
        while (root != null) {
            Container parent = root.getParent();
            if (!((root = parent) instanceof JComponent) || !(root instanceof JViewport) && !(root instanceof JInternalFrame)) continue;
            return root;
        }
        return null;
    }

    private static void scrollToVisible(@Nonnull Robot robot, @Nonnull JComponent container, @Nonnull Component target) {
        if (robot == null) {
            Scrolling.$$$reportNull$$$0(3);
        }
        if (container == null) {
            Scrolling.$$$reportNull$$$0(4);
        }
        if (target == null) {
            Scrolling.$$$reportNull$$$0(5);
        }
        Rectangle r = SwingUtilities.convertRectangle(target.getParent(), target.getBounds(), container);
        Scrolling.scrollToVisible(robot, container, (Rectangle)Preconditions.checkNotNull((Object)r));
    }

    private static void scrollToVisible(@Nonnull Robot robot, final @Nonnull JComponent c, final @Nonnull Rectangle rectangle) {
        if (robot == null) {
            Scrolling.$$$reportNull$$$0(6);
        }
        if (c == null) {
            Scrolling.$$$reportNull$$$0(7);
        }
        if (rectangle == null) {
            Scrolling.$$$reportNull$$$0(8);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                c.scrollRectToVisible(rectangle);
            }
        });
        robot.waitForIdle();
    }

    private Scrolling() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rectangle";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/core/Scrolling";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "scrollToVisible";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findClosestValidatingRootAncestor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

