/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Point;
import java.awt.Robot;
import javax.annotation.Nonnull;
import org.fest.swing.awt.AWT;
import org.fest.swing.core.InputEventGenerator;
import org.fest.swing.core.Settings;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.exception.UnexpectedException;
import org.fest.swing.timing.Pause;
import org.fest.swing.util.Platform;
import org.fest.swing.util.RobotFactory;
import org.fest.util.Preconditions;

class RobotEventGenerator
implements InputEventGenerator {
    private static final int KEY_INPUT_DELAY = 200;
    private final Robot robot;
    private final Settings settings;

    RobotEventGenerator() {
        this(new Settings());
    }

    RobotEventGenerator(@Nonnull Settings settings) {
        if (settings == null) {
            RobotEventGenerator.$$$reportNull$$$0(0);
        }
        this(new RobotFactory(), settings);
    }

    RobotEventGenerator(@Nonnull RobotFactory robotFactory, @Nonnull Settings settings) {
        if (robotFactory == null) {
            RobotEventGenerator.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            RobotEventGenerator.$$$reportNull$$$0(2);
        }
        try {
            this.robot = robotFactory.newRobotInPrimaryScreen();
            if (Platform.isWindows() || Platform.isOSX()) {
                Pause.pause(500L);
            }
        }
        catch (AWTException e) {
            throw UnexpectedException.unexpected(e);
        }
        this.settings = settings;
        settings.attachTo(this.robot);
    }

    @Nonnull
    Robot robot() {
        Robot robot = this.robot;
        if (robot == null) {
            RobotEventGenerator.$$$reportNull$$$0(3);
        }
        return robot;
    }

    @Override
    public void pressMouse(@Nonnull Component c, @Nonnull Point where, int buttons) {
        Point p;
        if (c == null) {
            RobotEventGenerator.$$$reportNull$$$0(4);
        }
        if (where == null) {
            RobotEventGenerator.$$$reportNull$$$0(5);
        }
        if (!AWT.isPointInScreenBoundaries(p = (Point)Preconditions.checkNotNull((Object)AWT.translate(c, where.x, where.y)))) {
            throw ActionFailedException.actionFailure("The component to click is out of the boundaries of the screen");
        }
        this.pressMouse(p, buttons);
    }

    @Override
    public void pressMouse(@Nonnull Point where, int buttons) {
        if (where == null) {
            RobotEventGenerator.$$$reportNull$$$0(6);
        }
        this.moveMouse(where.x, where.y);
        this.pressMouse(buttons);
    }

    @Override
    public void pressMouse(int buttons) {
        this.robot.mousePress(buttons);
    }

    @Override
    public void releaseMouse(int buttons) {
        this.robot.mouseRelease(buttons);
    }

    @Override
    public void rotateMouseWheel(int amount) {
        this.robot.mouseWheel(amount);
    }

    @Override
    public void moveMouse(@Nonnull Component c, int x, int y) {
        if (c == null) {
            RobotEventGenerator.$$$reportNull$$$0(7);
        }
        Point p = (Point)Preconditions.checkNotNull((Object)AWT.translate(c, x, y));
        this.moveMouse(p.x, p.y);
    }

    @Override
    public void moveMouse(int x, int y) {
        this.robot.mouseMove(x, y);
    }

    @Override
    public void pressKey(int keyCode, char keyChar) {
        try {
            this.robot.keyPress(keyCode);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid key code '%d'", keyCode));
        }
    }

    @Override
    public void releaseKey(int keyCode) {
        this.robot.keyRelease(keyCode);
        if (!Platform.isOSX()) {
            return;
        }
        int delayBetweenEvents = this.settings.delayBetweenEvents();
        if (200 > delayBetweenEvents) {
            Pause.pause(200 - delayBetweenEvents);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robotFactory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/core/RobotEventGenerator";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/core/RobotEventGenerator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "robot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "pressMouse";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "moveMouse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

