/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.FocusOwnerFinderStrategy;
import org.fest.swing.core.HierarchyBasedFocusOwnerFinder;
import org.fest.swing.core.ReflectionBasedFocusOwnerFinder;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.util.Lists;
import org.fest.util.Preconditions;
import org.fest.util.VisibleForTesting;

public final class FocusOwnerFinder {
    private static final List<FocusOwnerFinderStrategy> STRATEGIES = Lists.newArrayList();

    @VisibleForTesting
    static void initializeStrategies() {
        FocusOwnerFinder.replaceStrategiesWith(new ReflectionBasedFocusOwnerFinder(), new HierarchyBasedFocusOwnerFinder());
    }

    @VisibleForTesting
    static void replaceStrategiesWith(FocusOwnerFinderStrategy ... strategies) {
        if (strategies == null) {
            FocusOwnerFinder.$$$reportNull$$$0(0);
        }
        STRATEGIES.clear();
        STRATEGIES.addAll(Lists.newArrayList((Object[])strategies));
    }

    @Nonnull
    @VisibleForTesting
    static List<FocusOwnerFinderStrategy> strategies() {
        ArrayList arrayList = Lists.newArrayList(STRATEGIES);
        if (arrayList == null) {
            FocusOwnerFinder.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Nullable
    @RunsInEDT
    public static Component inEdtFocusOwner() {
        return GuiActionRunner.execute(new GuiQuery<Component>(){

            @Override
            @Nullable
            protected Component executeInEDT() {
                return FocusOwnerFinder.focusOwner();
            }
        });
    }

    @Nullable
    @RunsInCurrentThread
    public static Component focusOwner() {
        for (FocusOwnerFinderStrategy strategy : STRATEGIES) {
            Component focusOwner = FocusOwnerFinder.focusOwnerFrom((FocusOwnerFinderStrategy)Preconditions.checkNotNull((Object)strategy));
            if (focusOwner == null) continue;
            return focusOwner;
        }
        return null;
    }

    @Nullable
    private static Component focusOwnerFrom(@Nonnull FocusOwnerFinderStrategy strategy) {
        if (strategy == null) {
            FocusOwnerFinder.$$$reportNull$$$0(2);
        }
        try {
            return strategy.focusOwner();
        }
        catch (Exception e) {
            return null;
        }
    }

    private FocusOwnerFinder() {
    }

    static {
        FocusOwnerFinder.initializeStrategies();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategies";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/core/FocusOwnerFinder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/core/FocusOwnerFinder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "strategies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceStrategiesWith";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "focusOwnerFrom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

