/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.util.Platform;
import org.fest.swing.util.ToolkitProvider;
import org.fest.util.Preconditions;

public class AWT {
    private static final String ROOT_FRAME_CLASSNAME = SwingUtilities.class.getName() + "$";
    private static final ToolkitProvider TOOLKIT_PROVIDER = ToolkitProvider.instance();

    public static boolean isPointInScreenBoundaries(@Nonnull JComponent c, @Nonnull Point p) {
        if (c == null) {
            AWT.$$$reportNull$$$0(0);
        }
        if (p == null) {
            AWT.$$$reportNull$$$0(1);
        }
        Point where = AWT.translate(c, p.x, p.y);
        Rectangle screen = new Rectangle(TOOLKIT_PROVIDER.defaultToolkit().getScreenSize());
        return screen.contains(where);
    }

    public static boolean isPointInScreenBoundaries(@Nonnull Point p) {
        if (p == null) {
            AWT.$$$reportNull$$$0(2);
        }
        Rectangle screen = new Rectangle(TOOLKIT_PROVIDER.defaultToolkit().getScreenSize());
        return screen.contains(p);
    }

    @Nullable
    @RunsInCurrentThread
    public static Point translate(@Nonnull Component c, int x, int y) {
        Point p;
        if (c == null) {
            AWT.$$$reportNull$$$0(3);
        }
        if ((p = AWT.locationOnScreenOf(c)) == null) {
            return null;
        }
        p.translate(x, y);
        return p;
    }

    @Nonnull
    @RunsInEDT
    public static Point visibleCenterOf(final @Nonnull Component c) {
        if (c == null) {
            AWT.$$$reportNull$$$0(4);
        }
        Point center = GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                if (c instanceof JComponent) {
                    return AWT.centerOfVisibleRect((JComponent)c);
                }
                return AWT.centerOf(c);
            }
        });
        Point point = (Point)Preconditions.checkNotNull((Object)center);
        if (point == null) {
            AWT.$$$reportNull$$$0(5);
        }
        return point;
    }

    @Nonnull
    @RunsInCurrentThread
    public static Point centerOf(@Nonnull Component c) {
        if (c == null) {
            AWT.$$$reportNull$$$0(6);
        }
        Dimension size = c.getSize();
        Point point = new Point(size.width / 2, size.height / 2);
        if (point == null) {
            AWT.$$$reportNull$$$0(7);
        }
        return point;
    }

    @Nonnull
    @RunsInCurrentThread
    public static Point centerOfVisibleRect(@Nonnull JComponent c) {
        if (c == null) {
            AWT.$$$reportNull$$$0(8);
        }
        Rectangle r = c.getVisibleRect();
        Point point = AWT.centerOf((Rectangle)Preconditions.checkNotNull((Object)r));
        if (point == null) {
            AWT.$$$reportNull$$$0(9);
        }
        return point;
    }

    @Nonnull
    @RunsInCurrentThread
    public static Point centerOf(@Nonnull Rectangle r) {
        if (r == null) {
            AWT.$$$reportNull$$$0(10);
        }
        Point point = new Point(r.x + r.width / 2, r.y + r.height / 2);
        if (point == null) {
            AWT.$$$reportNull$$$0(11);
        }
        return point;
    }

    @Nonnull
    @RunsInCurrentThread
    public static Insets insetsFrom(@Nonnull Container c) {
        block5: {
            Insets insets;
            if (c == null) {
                AWT.$$$reportNull$$$0(12);
            }
            try {
                Insets insets2 = c.getInsets();
                if (insets2 == null) break block5;
                insets = insets2;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (insets == null) {
                AWT.$$$reportNull$$$0(13);
            }
            return insets;
        }
        Insets insets = new Insets(0, 0, 0, 0);
        if (insets == null) {
            AWT.$$$reportNull$$$0(14);
        }
        return insets;
    }

    public static boolean isAppletViewer(@Nullable Component c) {
        return c != null && "sun.applet.AppletViewer".equals(c.getClass().getName());
    }

    public static boolean isSharedInvisibleFrame(@Nullable Component c) {
        if (c == null) {
            return false;
        }
        return c instanceof Frame && (c == JOptionPane.getRootFrame() || c.getClass().getName().startsWith(ROOT_FRAME_CLASSNAME));
    }

    @RunsInCurrentThread
    public static boolean isHeavyWeightPopup(@Nonnull Component c) {
        if (c == null) {
            AWT.$$$reportNull$$$0(15);
        }
        if (!(c instanceof Window) || c instanceof Dialog || c instanceof Frame) {
            return false;
        }
        String name = AWT.obtainNameSafely(c);
        if ("###overrideRedirect###".equals(name) || "###focusableSwingPopup###".equals(name)) {
            return true;
        }
        String typeName = c.getClass().getName();
        return typeName.contains("PopupFactory$WindowPopup") || typeName.contains("HeavyWeightWindow");
    }

    @Nullable
    @RunsInCurrentThread
    private static String obtainNameSafely(@Nonnull Component c) {
        if (c == null) {
            AWT.$$$reportNull$$$0(16);
        }
        try {
            return c.getName();
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Nullable
    @RunsInCurrentThread
    public static Component invokerOf(@Nonnull Component c) {
        if (c == null) {
            AWT.$$$reportNull$$$0(17);
        }
        if (c instanceof JPopupMenu) {
            return ((JPopupMenu)c).getInvoker();
        }
        Container parent = c.getParent();
        return parent != null ? AWT.invokerOf(parent) : null;
    }

    @Nullable
    @RunsInCurrentThread
    public static Point locationOnScreenOf(@Nonnull Component c) {
        if (c == null) {
            AWT.$$$reportNull$$$0(18);
        }
        if (!AWT.isAWTTreeLockHeld()) {
            return new Point(c.getLocationOnScreen());
        }
        if (!c.isShowing()) {
            return null;
        }
        Point location = new Point(c.getLocation());
        if (c instanceof Window) {
            return location;
        }
        Container parent = c.getParent();
        if (parent == null) {
            return null;
        }
        Point parentLocation = AWT.locationOnScreenOf(parent);
        if (parentLocation != null) {
            location.translate(parentLocation.x, parentLocation.y);
            return location;
        }
        return null;
    }

    public static boolean popupOnPress() {
        return !Platform.isWindows();
    }

    public static int popupMask() {
        return 4;
    }

    public static boolean isAWTTreeLockHeld() {
        Frame[] frames = Frame.getFrames();
        if (frames.length == 0) {
            return false;
        }
        Object treeLock = Preconditions.checkNotNull((Object)frames[0].getTreeLock());
        ThreadStateChecker checker = new ThreadStateChecker(treeLock);
        try {
            checker.start();
            if (checker.isAlive()) {
                checker.join(100L);
            }
            return checker.isAlive();
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    private AWT() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/awt/AWT";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/awt/AWT";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "visibleCenterOf";
                break;
            }
            case 7: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "centerOf";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "centerOfVisibleRect";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "insetsFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isPointInScreenBoundaries";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "translate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visibleCenterOf";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 6: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "centerOf";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "centerOfVisibleRect";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "insetsFrom";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isHeavyWeightPopup";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "obtainNameSafely";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "invokerOf";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "locationOnScreenOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ThreadStateChecker
    extends Thread {
        private final Object lock;

        public ThreadStateChecker(@Nonnull Object lock) {
            if (lock == null) {
                ThreadStateChecker.$$$reportNull$$$0(0);
            }
            super("Thread state checker");
            this.setDaemon(true);
            this.lock = lock;
        }

        @Override
        public synchronized void start() {
            super.start();
            try {
                this.wait(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this;
            synchronized (object) {
                this.notifyAll();
            }
            object = this.lock;
            synchronized (object) {
                this.setName(super.getName());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", "lock", "org/fest/swing/awt/AWT$ThreadStateChecker", "<init>"));
        }
    }
}

