/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.annotation.GUITest;

public final class GUITestFinder {
    public static boolean isGUITest(@Nonnull Class<?> type, @Nonnull Method method) {
        if (type == null) {
            GUITestFinder.$$$reportNull$$$0(0);
        }
        if (method == null) {
            GUITestFinder.$$$reportNull$$$0(1);
        }
        return GUITestFinder.isGUITest(type) || GUITestFinder.isGUITest(method) || GUITestFinder.isSuperClassGUITest(type, method);
    }

    private static boolean isSuperClassGUITest(@Nonnull Class<?> type, @Nonnull Method method) {
        if (type == null) {
            GUITestFinder.$$$reportNull$$$0(2);
        }
        if (method == null) {
            GUITestFinder.$$$reportNull$$$0(3);
        }
        for (Class<?> superclass = type.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            if (GUITestFinder.isGUITest(superclass)) {
                return true;
            }
            Method overriden = GUITestFinder.findMethod(superclass, method);
            if (overriden == null || !GUITestFinder.isGUITest(overriden)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static Method findMethod(@Nonnull Class<?> type, @Nonnull Method method) {
        if (type == null) {
            GUITestFinder.$$$reportNull$$$0(4);
        }
        if (method == null) {
            GUITestFinder.$$$reportNull$$$0(5);
        }
        try {
            return type.getDeclaredMethod(method.getName(), method.getParameterTypes());
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static boolean isGUITest(@Nonnull AnnotatedElement annotatedElement) {
        if (annotatedElement == null) {
            GUITestFinder.$$$reportNull$$$0(6);
        }
        return annotatedElement.isAnnotationPresent(GUITest.class);
    }

    private GUITestFinder() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotatedElement";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/annotation/GUITestFinder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isGUITest";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuperClassGUITest";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

