/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.batch.utils;

import com.intellij.batch.model.BatchArtifactRefBean;
import com.intellij.batch.model.BatchXmlDomModelManager;
import com.intellij.batch.model.BatchXmlModel;
import com.intellij.batch.model.batch.BatchArtifactRef;
import com.intellij.batch.model.job.Identified;
import com.intellij.batch.model.job.IdentifiedContainer;
import com.intellij.cdi.jam.CdiJamModel;
import com.intellij.cdi.jam.CdiNamedBean;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.hash.HashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BatchCommonUtils {
    private BatchCommonUtils() {
    }

    public static boolean isBatchInstalled(@Nullable Module module) {
        if (module == null || module.isDisposed()) {
            return false;
        }
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass("javax.batch.api.Batchlet", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)) != null;
    }

    public static Set<BatchArtifactRefBean> getBatchArtifactRefs(@NotNull Module module) {
        if (module == null) {
            BatchCommonUtils.$$$reportNull$$$0(0);
        }
        if (module.isDisposed()) {
            return Collections.emptySet();
        }
        HashSet all = new HashSet();
        for (CdiNamedBean namedBean : CdiJamModel.getModel((Module)module).getNamedBeans()) {
            all.add(new BatchArtifactRefBean.NAMED_BEAN(namedBean));
        }
        List<BatchXmlModel> models = BatchXmlDomModelManager.getInstance(module.getProject()).getAllBatchXmlModels(module);
        for (BatchXmlModel model : models) {
            for (BatchArtifactRef ref : model.getBatchArtifacts().getRefs()) {
                all.add(new BatchArtifactRefBean.BATCH_ARTIFACT_REF(ref));
            }
        }
        return all;
    }

    @NotNull
    public static List<Identified> getAllIdentified(@Nullable IdentifiedContainer identifiedContainer) {
        if (identifiedContainer == null) {
            List<Identified> list = Collections.emptyList();
            if (list == null) {
                BatchCommonUtils.$$$reportNull$$$0(1);
            }
            return list;
        }
        ArrayList<Identified> identifiedList = new ArrayList<Identified>();
        BatchCommonUtils.addIdentified(identifiedContainer, identifiedList);
        ArrayList<Identified> arrayList = identifiedList;
        if (arrayList == null) {
            BatchCommonUtils.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static void addIdentified(IdentifiedContainer identifiedContainer, List<Identified> identifiedList) {
        identifiedList.addAll(identifiedContainer.getDecisions());
        identifiedList.addAll(identifiedContainer.getSplits());
        identifiedList.addAll(identifiedContainer.getSteps());
        identifiedList.addAll(identifiedContainer.getFlows());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/batch/utils/BatchCommonUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/batch/utils/BatchCommonUtils";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllIdentified";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBatchArtifactRefs";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

